package JIRA::REST::Class::Issue::Changelog;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents the changelog of a JIRA issue as an object.

__PACKAGE__->mk_contextual_ro_accessors(qw/ changes /);

sub init {
    my $self = shift;
    $self->SUPER::init(@_);

    $self->{data} = $self->issue->get('?expand=changelog');
    my $changes = $self->{changes} = [];

    foreach my $change ( @{ $self->data->{changelog}->{histories} } ) {
        push @$changes, $self->issue->make_object('change', { data => $change });
    }
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Changelog - A helper class for C<JIRA::REST::Class> that represents the changelog of a JIRA issue as an object.

=head1 VERSION

version 0.01

=head1 METHODS

=head2 B<changes>

Returns a list of individual changes, as C<JIRA::REST::Class::Issue::Changelog::Change> objects.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
