package App::Manoc::DB::Search::Result::Item;
#ABSTRACT: A generic search result item

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION


has 'timestamp' => (
    is      => 'ro',
    isa     => 'Int',
    default => 0,
);


has 'match' => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);


has 'key' => (
    is      => 'ro',
    lazy    => 1,
    builder => '_build_key',
);


has 'text' => (
    is       => 'ro',
    isa      => 'Str',
    required => 0,
);

sub _build_key { $_[0]->match }

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::DB::Search::Result::Item - A generic search result item

=head1 VERSION

version 2.99.4

=head1 ATTRIBUTES

=head2 timestamp

unixtime

=head2 match

=head2 key

used for sorting, defaults to match

=head2 text

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
