package App::Manoc::DB::Result::UserGroup;

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('user_groups');
__PACKAGE__->add_columns(
    user_id => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    },
    group_id => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    }
);

__PACKAGE__->set_primary_key(qw/user_id group_id/);

__PACKAGE__->belongs_to( user       => 'App::Manoc::DB::Result::User',  'user_id' );
__PACKAGE__->belongs_to( user_group => 'App::Manoc::DB::Result::Group', 'group_id' );


1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::UserGroup

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

This is an object that represents a row in the 'user_groups' table of your
application database.  It uses DBIx::Class (aka, DBIC) to do ORM.

=head1 NAME

App::Manoc::DB::Result::UserGroup - A model object representing the JOIN between Users and
Groups.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
