package App::Manoc::ControllerBase::APIv1CRUD;
#ABSTRACT: Base class for API controllers

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'App::Manoc::ControllerBase::APIv1'; }

with
    'App::Manoc::ControllerRole::ResultSet',
    'App::Manoc::ControllerRole::ObjectForm',
    'App::Manoc::ControllerRole::ObjectList',
    'App::Manoc::ControllerRole::ObjectSerializer',
    'App::Manoc::ControllerRole::JSONView';

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            Chained => 'deserialize',
        }
    },
    class      => 'ManocDB::Building',
    form_class => 'App::Manoc::Form::Building',
);



sub list : Chained('object_list') PathPart('') Args(0) {
    my ( $self, $c ) = @_;

    $c->forward("object_list_js");
}


sub view : Chained('object') : PathPart('') : Args(0) {
    my ( $self, $c, $id ) = @_;

    $c->forward('object_view_js');
}


sub create : Chained('base') PathPart('') Args(0) POST {
    my ( $self, $c ) = @_;

    $c->forward("object_form_create");
    $c->forward("api_form");
}


sub update : Chained('object') PathPart('') Args(0) POST {
    my ( $self, $c ) = @_;

    $c->forward("object_form_edit");
    $c->forward("api_form");
}


sub api_form : Private {
    my ( $self, $c ) = @_;

    my $form = $c->stash->{form};

    if ( $form->is_valid ) {
        $c->stash->{api_response_data} = {
            object_id => $form->item_id,
            status    => 'success',
        };
    }
    else {
        $c->stash(
            api_field_errors => {
                errors => $form->form_errors || "",
                field_errors => [ $form->errors_by_name, ],
            }
        );
    }
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ControllerBase::APIv1CRUD - Base class for API controllers

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

This class can be used as a base for controllers using the L<App::Manoc::ControllerRole::CommonCRUD> role.

=head1 ACTIONS

=head2 list

GET api/v1/<namespace>

=head2 view

GET api/v1/<namespace>/<id>

=head2 create

POST api/v1/<namespace>/create

=head2 update

POST api/v1/<namespace>/<id>

=for Pod::Coverage api_form

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
