// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SpinFuzzyBarrier_h
#define SpinFuzzyBarrier_h
#pragma once

//
//	Implement a UNIX process fuzzy barrier using spinning on shared memory.
//	A fuzzy barrier is akin to a barrier, but it allows us to distinguish
//	the entry to the barrier from the synchronization point.
//

#include <SpinLock.h>
#include <AwesimeConfig.h>
#include <assert.h>

class SpinFuzzyBarrier : public SpinBarrier {
    short pHeight;
    short pCount;
    short generation;
    short pLoops;
    int pMaxLoops;

public:
    SpinFuzzyBarrier(int h, int loops = DefaultSpinFuzzyBarrierLoops,
		     int max = 0 );
    ~SpinFuzzyBarrier();

    //
    // rendez() - join the barrier crowd. We return the generation count
    // at when we joined. We use this with vous() to determine if the
    // the barrier has been met. Thus, rendezvous() is equivilent to
    // vous(rendez()).
    //
    int rendez();
    int vous(int);
};

static inline
SpinFuzzyBarrier::SpinFuzzyBarrier( int h, int l, int m ) : (h, l, m)
{
    // empty
}

#ifndef USE_SHARED_MEMORY
static inline int
SpinFuzzyBarrier::rendez()
{
    assert( (pCount+1) == pHeight );
    int gen = generation;
    generation++;
    pCount = 0;
    return(gen);
}

static inline int
SpinFuzzyBarrier::vous(int gen)
{
    assert( gen < generation );
    return(1);
}
#endif /* USE_SHARED_MEMORY */

#endif /* SpinFuzzyBarrier */
