// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SingleCpuMux_h
#define SingleCpuMux_h
#pragma once

#include <CpuMultiplexor.h>

class SingleCpuMux : public CpuMultiplexor {
    friend class SingleSimMux;

protected:
    virtual Thread *remove();
    //
    // Constructors of this class and all subclasses should call their
    // own allocateLocalEventStructures, because constructors automatically
    // chain the calls.
    //
    // Use allocateEventStructures when allocating resources for a CPU and
    // you're not in the constructor. Use deallocateEventStructures for
    // removing those resources. These routines should call subclass
    // instances of the same names.
    //
    void allocateLocalEventStructures(int,int);
    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

public:
    SingleCpuMux(int debug = 0);
    virtual ~SingleCpuMux();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void add(Thread *);
};

//
//	These are things the user needs to define
//

extern ThreadContainer *AllocateHardwareCurrentEventsStructure();

#endif /* SingleCpuMux_h */
