// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "LockedHeap.h"
#include "stream.h"

LockedHeap::LockedHeap(int defaultLength = 0) : (defaultLength), heapLock(1)
{
    // empty
}

void
LockedHeap::add(AwesimeHeapItem &t)
{
    heapLock.reserve();
    AwesimeHeap::add(t);
    heapLock.release();
}

bool
LockedHeap::remove(AwesimeHeapItem &t)
{
    heapLock.reserve();
    bool ok = AwesimeHeap::remove(t);
    heapLock.release();
    return(ok);
}

bool
LockedHeap::doStart(AwesimeHeapIndex &)
{
    assert(0);
    return(0);
}

void
LockedHeap::doDone()
{
    assert(0);
}

unsigned int
LockedHeap::size()
{
    heapLock.reserve();
    unsigned int s = AwesimeHeap::size();
    heapLock.release();
    return(s);
}


void LockedHeap::classPrintOn(ostream& s)
{
    heapLock.reserve();
    s << * ((AwesimeHeap *) this) ;
    heapLock.release();
}
