// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef THREADCONTAINERH
#define THREADCONTAINERH
#pragma once

#include <Awesime.h>

class Thread;

class IndexedThreadContainer : {
    public :

    IndexedThreadContainer();

    virtual void add( Thread* );
    virtual void add( double when, Thread* );
    virtual void add( int when, Thread* );

    virtual void addIndexed( int, Thread* );
    virtual void addIndexed( int, double when, Thread* );
    virtual void addIndexed( int when, Thread* );

    virtual Thread* remove();
    virtual Thread* remove(Thread* toRemove);

    virtual bool isEmpty();
    virtual unsigned size();
};



#endif THREADCONTAINERH
