	.text
REGMASK = 0x3ffe		| save d1-d7, a0-a5
REGSAVE = 56			| # bytes needed to save registers
REGOFFSET=56

|REGPUSHMASK = 0x7ffc		| save d1-d7, a0-a5
|REGPULLMASK = 0x3ffe		| save d1-d7, a0-a5
|REGSAVE = 56			| # bytes needed to save registers
|REGOFFSET=56

FLOATMASK=0xff
FLOATSAVE=96
FLOATOFFSET= (REGOFFSET + FLOATSAVE)

TOTALSAVE=REGSAVE + FLOATSAVE

|
|	Data offsets into HardwareContext
|
THREAD_FP	=  0
THREAD_SP	=  4 + THREAD_FP
THREAD_BASE	=  4 + THREAD_SP
THREAD_END	=  4 + THREAD_BASE
THREAD_MAX	=  4 + THREAD_END

|
|	Stack offsets for arguments. The link is in 0, the return address
|	is in 4.
|
CONTEXT_FROM	= 8
CONTEXT_TO	= 12

|	CPU::switchTo(Thread*,Thread*)
|
| Transfer control from the active process to a new process.
|
	.text
#ifdef	__Cplusplus__
	.globl	__HardwareContext_magicSwitchTo
__HardwareContext_magicSwitchTo:
#endif

#ifdef	c_plusplus
	.globl _magicSwitchTo__15HardwareContextFP15HardwareContext
_magicSwitchTo__15HardwareContextFP15HardwareContext:
#endif

#ifdef	__GNUG__
	.globl _magicSwitchTo_PSHardwareContext_PSHardwareContext
 _magicSwitchTo_PSHardwareContext_PSHardwareContext:
#endif

	link	a6,#-TOTALSAVE			| reserve space on stack for saving reg
	moveml	#REGMASK,a6@(-REGOFFSET)	| save registers
	fmovem	#FLOATMASK,a6@(-FLOATOFFSET)| and floating point registers

	movl	a6@(CONTEXT_FROM),a0	| a4 = address of current Thread object
	movl	a6,a0@(THREAD_FP)	| TheCpu.thisProcess -> savedFP
	movl	a7,a0@(THREAD_SP)

	movl	a6@(CONTEXT_TO),a0	| a0 = address of dst Thread object
	movl	a0@(THREAD_FP),a6	| load FP of destination Thread Object
	movl	a0@(THREAD_SP),a7	| load SP of destination Thread

	fmovem	a6@(-FLOATOFFSET),#FLOATMASK
	moveml	a6@(-REGOFFSET),#REGMASK	| restore registers
	unlk	a6		| restore FP
	rts

#ifdef	__Cplusplus__
	.globl __HardwareContext_getSp
__HardwareContext_getSp:
#endif

#ifdef	c_plusplus
	.globl _getSp__15HardwareContextFv
_getSp__15HardwareContextFv:
#endif

#ifdef	__GNUG__
	.globl _getSp_PSHardwareContext
_getSp_PSHardwareContext:
#endif
	movl	a7,d0
	rts
