#include <Gate.h>
#include "CpuMultiplexorP.h"

Gate::~Gate()
{
    lock.reserve();
    assert( pPileOfThreads.isEmpty() );
    lock.release();
}

//
//	This is only executed in the context of a CpuMultiplexor, never
//	a thread.
//

void
Gate::hiddenWait()
{
    ThisCpu -> reserveByException( this );
}

int
Gate::reserveByException(Thread *byWho)
{
    bool blocked = 0;

    lock.reserve();
    if ( pState == GateLocked ) {
	pPileOfThreads.add( byWho );
	blocked = 1;
    }
    lock.release();

    return( blocked );
}

void
Gate::open()
{
    lock.reserve();
    pState = GateUnlocked;

    while ( ! pPileOfThreads.isEmpty() ) {
	Thread *p = (Thread *) (pPileOfThreads.remove());
	ThisCpu -> add(p);
    }
    
    lock.release();
}
