// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef Event_h
#define Event_h
#pragma once

//
//	Event.h
//	The barrier is initially closed.
// 

#include <ReserveByException.h>
#include <FifoScheduler.h>
#include <SpinLock.h>

class Event : public ReserveByException {
    SpinLock lock;
    short garcon;
    short generation;
    short pLoops;

    FifoScheduler pPileOfThreads;
    
    void releaseAll();
    
private:
    virtual int reserveByException(Thread *byWho);
    
public:
    
    Event(int loops = 0);
    virtual ~Event();

    virtual int size();

    void waitFor();
    void trigger();
};

static inline
Event::Event(int l)
{
    garcon = 0;
    generation = 0;
    pLoops = l;
}

#endif /* Event_h */
