// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef CpuMuxExceptions_h
#define CpuMuxExceptions_h
#pragma once

#include <ExceptionClass.h>

//
//	ExceptionByReserve -- Used to reserve a semaphore/barrier/etc
//
class ReserveByException;

class ExceptionReserve : public ExceptionClass {
    ReserveByException *toReserve;
public:
    ReserveByException *reserve();
    void reserve(ReserveByException *);
    
    virtual void handleException();
};

static inline ReserveByException *
ExceptionReserve::reserve()
{
    return(toReserve);
}

static inline void
ExceptionReserve::reserve(ReserveByException *r)
{
    toReserve = r;
}


//
//	ExceptionTerminate -- used to terminate a thread
//
class Thread;

class ExceptionTerminate : public ExceptionClass {
    Thread *deadThread; 
public:
    void terminate(Thread *);
    virtual void handleException();
};

static inline void
ExceptionTerminate::terminate(Thread *r)
{
    deadThread = r;
}

//
//	ExceptionReschedule -- used to relenquish the CPU.
//

class ExceptionReschedule : public ExceptionClass {
public:
    virtual void handleException();
};

//
//	ExceptionIveSuspended -- used when current thread has suspended
//	itself and another thread must be scheduled and run.
//

class ExceptionIveSuspended : public ExceptionClass {
public:
    virtual void handleException();
};

#endif /* CpuMuxExceptions_h */
