// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef CpuMultiplexorP_h
#define CpuMultiplexorP_h
#pragma once

#include <CpuMultiplexor.h>
#include <HardwareContext.h>
#include <HardwareContextP.h>
#include <SpinLock.h>
#include <Thread.h>

extern SpinLock CpuCerrLock;

static inline void
CpuMultiplexor::addUnlocked(Thread *who)
{
    //
    // Add them to the list of current events
    //
    myCurrentEvents -> add( who );
}

//
//	Expansions for exception handling
//

static inline void
CpuMultiplexor::raise(ExceptionClass *by)
{
    assert( by != 0 );
    raisedBy = by;
    currentThread -> pContext.switchContext( &systemContext );
}

static inline void
CpuMultiplexor::reserveByException( ReserveByException *sem )
{
    reserveException.reserve(sem);
    raise( &reserveException );
}

static inline void
CpuMultiplexor::threadTerminateException( Thread *killMe )
{
    terminateException.terminate( killMe );
    raise( &terminateException );
}

//
//	These are things the user needs to define
//

extern ThreadContainer *AllocateHardwareCurrentEventsStructure();

#endif /* CpuMultiplexorP_h */
