// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "Barrier.h"
#include "CpuMultiplexor.h"
#include "CpuMultiplexorP.h"
#include "Thread.h"

Barrier::~Barrier()
{
}

void
Barrier::releaseAll()
{
    while ( ! pPileOfThreads.isEmpty() ) {
	Thread *p = (Thread *) (pPileOfThreads.remove());
	ThisCpu -> add(p);
    }
}

//
//	Make everyone exit
//
void
Barrier::lowerBarrier()
{
    lock.reserve();
    generation++;
    pCount = 0;
    releaseAll();
    lock.release();
}

void
Barrier::rendezvous()
{
    lock.reserve();
    if ( pCount == pHeight-1) {
	pCount = 0;
	generation++;
	releaseAll();
	lock.release();
    } else {
	int gen = generation;
	pCount++;
	lock.release();
	for (int i = 0; i < pLoops; i++) {
	    if (gen != generation) break;
	}
	if (gen == generation) {
	    ThisCpu -> reserveByException( this );
	}
    }
}

int
Barrier::reserveByException(Thread *byWho)
{
    int blocked = 0;

    lock.reserve();
    if ( pCount == pHeight) {
	pCount = 0;
	generation++;
	releaseAll();
    } else {
	pPileOfThreads.add( byWho );
	blocked = 1;
    }
    lock.release();

    return( blocked );
}

void
Barrier::height(int newHeight)
{
    lock.reserve();
    if (pCount >= newHeight) {
	pCount = 0;
	generation++;
	releaseAll();
    }
    else {
	pHeight = newHeight;
    }
    lock.release();
}
