// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "SingleSimMux.h"
#include "CpuMultiplexorP.h"
#include "AwesimeHeap.h"
#include "Thread.h"
#include "TimeSchedulerSplayPQ.h"
#include "ReserveByException.h"
#include <math.h>

extern int CpuMuxDebugFlag;

SingleSimMux::SingleSimMux(int debug ) : SimulationMultiplexor(debug)
{
    ThisSimulationMultiplexor = this;
    ThisCpu = &singleCpu;
    cpu = &singleCpu;

    singleCpu.allocateLocalEventStructures(0,1);
    SingleSimMux::allocateLocalEventStructures(0,1);

    singleCpu.pNameTemplate = "SingleSimMux";
    sprintf(singleCpu.nameSpace, "[%s-%d] ",
	    singleCpu.pNameTemplate, singleCpu.iYam);
    singleCpu.pName = singleCpu.nameSpace;
}

void
SingleSimMux::allocateLocalEventStructures(int, int)
{
    myPendingEvents = new TimeSchedulerSplayPQ;
}

void
SingleSimMux::allocateEventStructures(int newIYam, int outOf)
{
    allocateLocalEventStructures(newIYam, outOf);

    //
    // must do this after the local structures get set up so that
    // CpuMultiplexors does not increase until all data structures are
    // in place, otherwise people may poke at them before they're set up.
    //

    //CpuMultiplexor::allocateEventStructures(newIYam, outOf);
}

void
SingleSimMux::deallocateEventStructures()
{

//    CpuMultiplexor::deallocateEventStructures();

    delete myPendingEvents;
    myPendingEvents = 0;
}

void
SingleSimMux::warmThePot(int)
{
    singleCpu.warmThePot(1);
}

void
SingleSimMux::stirItAround()
{
    while( ! *(singleCpu.terminated) ) {

	singleCpu.stirItAround();

	if ( advanceTime() < 1 ) {
	    return;
	}
    }

    if ( CpuMuxDebugFlag ) {
	cerr << name() << "termination signaled, loop ends, exit\n";
    }
}

void
SingleSimMux::coolItDown()
{
    singleCpu.coolItDown();
}

int
SingleSimMux::advanceTime()
{
    if ( ! myPendingEvents -> empty() ) {
	CurrentSimulatedTime = (myPendingEvents -> front()).time();
    }

    int added = 0;
    
    while ( ! myPendingEvents -> empty() ) {

	TimeScheduler &item = myPendingEvents -> front();

	if ( item.time() > CurrentSimulatedTime )
	    break;

	singleCpu.addUnlocked( item.thread() );
	added++;
	myPendingEvents -> del_front();
    } 
    return(added);
}
