// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "CpuMultiplexor.h"
#include "Thread.h"
#include "ThreadContainer.h"
#include "ReserveByException.h"
#include <math.h>

static const int NOTREACHED = 0;

int CpuMultiplexors;
CpuMultiplexor *ThisCpu;
SpinLock CpuCerrLock;

//
//	This can not be private, or we wont see all the action
//

volatile int StopCpuMux;
int CpuMuxDebugFlag = 0;

CpuMultiplexor::CpuMultiplexor(int debug) : systemContext(0, 0)
{
    pNameTemplate = "CpuMux";
    currentThread = 0;
    enabled = 0;
    iYam = 0;
    pid = 0;
    CpuMuxDebugFlag = debug;
    ThisCpu = this;
    terminated = &StopCpuMux;
    sprintf(nameSpace, "[%s-%d] ", pNameTemplate, iYam);
    pName = nameSpace;
}

CpuMultiplexor::~CpuMultiplexor()
{
    // empty
}

void
CpuMultiplexor::debug(int newdebug)
{
    CpuMuxDebugFlag = newdebug;
}

int
CpuMultiplexor::debug()
{
    return(CpuMuxDebugFlag);
}

void
CpuMultiplexor::terminateAll()
{
    StopCpuMux = 1;
}

//void
//CpuMultiplexor::allocateLocalEventStructures(int newIYam, int outOf)
//{
//    // empty
//}

void
CpuMultiplexor::allocateEventStructures(int newIYam, int outOf)
{
    // empty
}

void
CpuMultiplexor::deallocateEventStructures()
{
    // empty
}

void
CpuMultiplexor::fireItUp(int, unsigned)
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::warmThePot(int)
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::coolItDown()
{
    assert( NOTREACHED );
}

void
CpuMultiplexor::add(Thread*)
{
    assert( NOTREACHED );
}

Thread *
CpuMultiplexor::remove()
{
    assert( NOTREACHED );
    return(0);
}

//
// This is the job dispatcher.
//

void
CpuMultiplexor::stirItAround()
{
    assert( NOTREACHED );
}
