#include <stream.h>

#include "SimulationMultiplexor.h"

#include "Server.h"

Server::Server(int nMax, double mean, RNG *rng)
      : Thread( "SERVER", 10000),
	serviceTime(mean, rng)
{
    maxCustomers = nMax;
    delayedCustomers = 0;
    totalDelay = 0.0;
    timeByDelayedCustomer = 0.0;
    lastEvent = 0.0;
}

void
Server::main()
{
    for (int customerNo = 0; customerNo < maxCustomers; customerNo++) {
	timeByDelayedCustomer +=
		(theQueue.size()) ?
			(theQueue.size() * (simulatedClock() - lastEvent)) :
			0.0;
	double *tmpVal;
	theQueue.remove((AwesimeFifoItem *)&tmpVal);
	double timeArrival = *tmpVal;
	delete tmpVal;

	delayedCustomers++;
	double delay = (simulatedClock() - timeArrival);
	totalDelay += delay;
	lastEvent = simulatedClock();
#if 0
	cout << "Server GOT " << timeArrival
	     << " at " << simulatedClock() << "\n"
	     << "\tdelay = " << delay << "\n"
	     << "\tQue Size = " << theQueue.size() << "\n"
	     << "\tdelayedCustomers = " << delayedCustomers << "\n"
	     << "\ttotalDelay = " << totalDelay << "\n"
	     << "\ttimeByDelayedCustomer = " << timeByDelayedCustomer << "\n";
#endif
	hold(serviceTime());
	//cout << "Server DONE at " << simulatedClock() << "\n";
    }

    double totalTime = simulatedClock();

    cout << "\n"
	 << "\tQueue Delay           \t" <<
	    (totalDelay / delayedCustomers) << "\n"
	 << "\tQueue Length          \t" <<
	    (timeByDelayedCustomer / totalTime) << "\n\n";
}

void
Server::add(double timeArrival)
{
    timeByDelayedCustomer += (theQueue.size()) ?
			      (theQueue.size() * (simulatedClock() - lastEvent))
			      : 0.0;
    double *tmpVal = new double;
    *tmpVal = timeArrival;

    CurrentThread() -> checkStack();

    theQueue.add((AwesimeFifoItem *)&tmpVal);
    lastEvent = simulatedClock();
}
