#include <stream.h>

#include "SimulationMultiplexor.h"

#include "Customer.h"
#include "Server.h"

Customer::Customer(int nMax, double mean, Server *server, RNG *rng)
	: ( "CUSTMR", 10000),
	  arrivalTime(mean, rng)
{
    maxCustomers = nMax;
    theServer = server;
}

void
Customer::main()
{
    for (int i = 0; i < maxCustomers; i++) {
	hold(arrivalTime());
	//cout << "Customer ADD at " << simulatedClock() << "\n";
	double arrTime = simulatedClock();
	theServer->add(arrTime);
    }
}
