(* Copyright (C) 1995, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Wed Jan 18 21:17:50 PST 1995 by najork                   *)
(*       Created on Wed Jan 18 20:59:43 PST 1995 by najork                   *)

(* An "Address.T" is an "ADDRESS". This interface is intended to be used to
   instantiate generic interfaces and modules such as "Table" and "List". *)

INTERFACE Address;

IMPORT Word;

CONST Brand = "Address-1.0";

TYPE T = ADDRESS;

PROCEDURE Equal(a, b: T): BOOLEAN;
(* Return "a = b". *)

PROCEDURE Hash(a: T): Word.T;
(* Return "LOOPHOLE(a, Word.T)". This assumes that "ADDRESS" and "INTEGER"
   have the same size. *)

PROCEDURE Compare(a, b: T): [-1..1];
(* Return "-1" if "a < b", "0" if "a = b", or "+1" if "a > b". *)

END Address.
