(* Copyright (C) 1995, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)

(* The SharedBoard data structure *)

INTERFACE SharedBoard;

IMPORT StableBoardX, StableError, Wr, Rd;

TYPE T = StableBoardX.T OBJECT
  OVERRIDES
    readCheckpoint  := ReadCheckpoint;
    writeCheckpoint := WriteCheckpoint;
  END;

CONST Brand = "SharedBoard";

PROCEDURE ReadCheckpoint(sb: T; rd: Rd.T) : StableBoardX.T
  RAISES {StableError.E};

PROCEDURE WriteCheckpoint(sb: T; wr: Wr.T) 
  RAISES {StableError.E};

END SharedBoard.
