(* Copyright (C) 1993, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)

MODULE FontCache;

IMPORT Font, TextRefTbl, IO, Stdio;

VAR table := NEW (TextRefTbl.Default).init (100);
VAR debug := 0;

PROCEDURE Get (READONLY name: TEXT): Font.T =
  VAR fontref: REF Font.T;
  VAR refany:  REFANY;
  BEGIN
    IF debug=1 THEN
      IO.Put (name, Stdio.stderr);
    END;
    IF table.get (name, refany) THEN
      fontref := NARROW (refany, REF Font.T);
    ELSE
      fontref := NEW(REF Font.T);
      fontref^ := Font.FromName (ARRAY OF TEXT {name});
      EVAL table.put (name, fontref);
    END;
    RETURN fontref^;
  END Get;

(* non-cached version of the above
PROCEDURE Get (READONLY name: TEXT): Font.T =
  BEGIN
    RETURN Font.FromName (ARRAY OF TEXT {name});
  END Get;
*)

BEGIN
END FontCache.
