(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Created on Sep 15 1988 by Jorge Stolfi                      *)
(* Last modified on Mon Jun 21 19:35:07 PDT 1993 by steveg     *)
(*      modified on Sun Jul 19 11:49:42 PDT 1992 by harrison   *)
(*      modified on Fri Jan 12  9:36:04 PST 1990 by stolfi     *)

INTERFACE R2;

(* Real pairs.

   This interface implements the 2-dimensional vector space R^2. 
   It defines the basic linear operations on real pairs (arrays 
   with 2 REAL components).  See R2x2.i3 and R2IO.i3 for 
   additional operations.  
   
   Index: vectors; reals, vectors of; 
   points; geometry; linear algebra; numerical routines
   
*)

(********************************************************************)
(*                                                                  *)
(* WARNING: DO NOT EDIT THIS FILE.  IT WAS GENERATED MECHANICALLY.  *)
(* See the  Makefile for more details.                              *)
(*                                                                  *)
(********************************************************************)

IMPORT Random;

TYPE
  Axis = [0..1];           (* Coordinate selectors *)
  Point = ARRAY Axis OF REAL;  (* A point of R2 *)
  T = Point;

CONST
  Origin = T{0.0, 0.0};
  Ones = T{1.0, 1.0};

PROCEDURE Unit(i: Axis): T;
  (* The unit vector on the i-th axis. *)

PROCEDURE Equal(READONLY x, y: T): BOOLEAN; 
  (* Equality *)

PROCEDURE IsZero(READONLY x: T): BOOLEAN;
  (* TRUE if x = (0 0) *)

PROCEDURE Sum (READONLY x: T): REAL;
  (* Sum of the coordinates x[i]. *)

PROCEDURE Max(READONLY x: T): REAL;
  (* Maximum of the x[i]. *)

PROCEDURE MaxAbsAxis(READONLY x: T): Axis;
  (* Index i such that ABS(x[i]) is largest. *)

PROCEDURE Min(READONLY x: T): REAL;
  (* Minimum of the x[i]. *)

PROCEDURE SumSq(READONLY x: T): REAL;
  (* Sum of x[i]**2. *)

PROCEDURE L1Norm(READONLY x: T): REAL;
  (* Sum of ABS(x[i]). *)

PROCEDURE Length(READONLY x: T): REAL;
PROCEDURE L2Norm(READONLY x: T): REAL;
  (* Euclidean length (sqrt of sum of x[i]**2). *)

PROCEDURE LInfNorm(READONLY x: T): REAL;
  (* Maximum of ABS(READONLY x[i]). *)

PROCEDURE L1Dist(READONLY x, y: T): REAL;
  (* L1Norm(Sub(x,y)). *)

PROCEDURE Dist(READONLY x, y: T): REAL;
PROCEDURE L2Dist(READONLY x, y: T): REAL;
  (* L2Norm(Sub(x,y)). *)

PROCEDURE L2DistSq(READONLY x, y: T): REAL;
  (* SumSq(Sub(x,y)). *)

PROCEDURE LInfDist(READONLY x, y: T): REAL;
  (* LInfNorm(Sub(x,y)). *)

PROCEDURE RelDist(READONLY x, y: T; eps: REAL := 1.0e-37): REAL;
  (* Relative distance between two points, useful in convergence tests.
  The /eps/ parameter specifies the magnitude of the (additive) noise
  in each coordinate. 
  The value of RelDist is defined as   max_i rdist(x[i], y[i])  where 
|
|    rdist(u,v) =  max(|u-v|-eps, 0) / max(|u|, |v|, eps)
|
  The result is between 0.0 and 2.0. A result below 2.0e-7 means the vectors
  differ only at the roundoff error level. *)

PROCEDURE Dot (READONLY x, y: T): REAL;
  (* Dot product of vectors x and y. *)

PROCEDURE Cos (READONLY x, y: T): REAL;
  (* Co-sine of the angle between x and y. *)

PROCEDURE Det(READONLY p0, p1: T): REAL;
  (* Determinant of the matrix with given points as rows *)

PROCEDURE Add(READONLY x, y: T): T; 
  (* Vector sum x + y. *)

PROCEDURE Sub(READONLY x, y: T): T; 
  (* Vector difference x - y. *)

PROCEDURE Minus(READONLY x: T): T; 
  (* Negation of all coordinates. *)

PROCEDURE Scale(alpha: REAL; READONLY x: T): T; 
  (* Scalar multiplication alpha * x.  *)

PROCEDURE Shift(READONLY x: T; delta: REAL): T;
  (* Adds delta to every coordinate of x. *)

PROCEDURE Mix (READONLY x: T; alpha: REAL; READONLY y: T; beta: REAL): T;
  (* Linear combination x * alpha + y * beta. *)

PROCEDURE Weigh (READONLY x, y: T): T;
  (* Returns z such that z[i] = x[i] * y[i]. *)

TYPE Function = PROCEDURE (x: REAL): REAL;

PROCEDURE FMap (READONLY x: T; F: Function): T;
  (* Returns z such that z[i] = F(x[i]). *)

PROCEDURE Direction(READONLY x: T): T; 
  (* Divides x by Length(x). An error if x = (0 0). *)

PROCEDURE Cross(READONLY p1: T): T;
  (* Cross product: Det(p, q, r, ...) = Dot(p, Cross(q, r, ...))  *)

PROCEDURE Throw(lo, hi: REAL; src: Random.T := NIL): T;
  (* Returns a random vector with coordinates independently and
  uniformly distributed between lo (inclusive) and hi (exclusive).
  The "src" parameter is the source of randomness (See Random.def).  *)

PROCEDURE ToText(READONLY x: T): TEXT;

END R2.
 
