
int parsebuffer_regn(void *b)
{
  int n;
  int mloc;

#if 0
  printf("Skipping\n");
  mloc = buffer_getloc(b);
  buffer_skip_bytes(b,4);
  n = buffer_read_int(b);
  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);
  buffer_skip_bytes(b,n);
#else

  int loc;
  int i,nn;
  char *s,*s2;
  void *btmp;
  unsigned char *buffer;
  unsigned char *obuffer = NULL;
  float f;
  unsigned int flags1,flags2,flags;
  int m,nuncomp,nin,nout,err;
  int ndata;

  mloc = buffer_getloc(b);
  buffer_skip_bytes(b,4);
  ndata = buffer_read_int(b);
  flags1 = buffer_read_uint(b);
  printf("flags 1 = ");
  printflags(flags1);
  m = buffer_read_int(b);
  printf("formid = %i\n",m);
  flags2 = buffer_read_uint(b);
  printf("flags 2 = ");
  printflags(flags2);

  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);

  if (flags1 & 0x00040000) {
    printf("Data is compressed\n");
    nuncomp = buffer_read_int(b);
    buffer = buffer_getbuf(b);
    nin = ndata-4;
    nout = 10*nin;
    obuffer = (unsigned char *)malloc(nout*sizeof(unsigned char));
    err = uncompress(obuffer,(uLongf *)(&nout),&(buffer[buffer_getloc(b)]),nin);
    if (err == Z_OK) {
      // printf("err = OK\n");
    } else if (err == Z_MEM_ERROR) {
      printf("err = MEM\n");
    } else if (err == Z_BUF_ERROR) {
      printf("err = BUF\n");
    } else if (err == Z_DATA_ERROR) {
      printf("err = DATA\n");
    } else {
      printf("Unknown error\n");
    }
    if (nout != nuncomp) {
      printf("Uncompressed data is of wrong size\n");
      exit(-1);
    }
    btmp = b;
    b = buffer_new(obuffer,(int)nout);
  } else {
    buffer = buffer_getbuf(b);
    btmp = b;
    b = buffer_new(&(buffer[buffer_getloc(btmp)]),ndata);
  }

  while (buffer_eof(b) != 1) {
    loc = buffer_getloc(b);
    s = buffer_read_string4(b);
    printf("Chunk name: %s\n",s);
    if (strcmp(s,"EDID") == 0) {
      n = buffer_read_short(b);
      printf("REGN/EDID %i\n",n);
      s2 = buffer_read_nstring(b,n);
      printf("%s\n",s2);
      free(s2);
    } else if (strcmp(s,"RCLR") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RCLR %i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
    } else if (strcmp(s,"WNAM") == 0) {
      n = buffer_read_short(b);
      printf("REGN/WNAM %i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
    } else if (strcmp(s,"RPLI") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RPLI %i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
    } else if (strcmp(s,"RPLD") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RPLD %i\n",n);
      m = n/4;
      for (i = 0; i < m; i++) {
	f = buffer_read_float(b);
	printf("%f\n",f);
      }
    } else if (strcmp(s,"RDAT") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDAT %i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
    } else if (strcmp(s,"RDMP") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDMP %i\n",n);
      s2 = buffer_read_nstring(b,n);
      printf("%s\n",s2);
      free(s2);
    } else if (strcmp(s,"RDMD") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDMD %i\n",n);
      n = buffer_read_int(b);
      printf("%i\n",n);
    } else if (strcmp(s,"RDSD") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDSD %i\n",n);
      m = n/12;
      for (i = 0; i < m; i++) {
	n = buffer_read_int(b);
	printf("%i\n",n);
	n = buffer_read_int(b);
	printf("%i\n",n);
	n = buffer_read_int(b);
	printf("%i\n",n);
      }
    } else if (strcmp(s,"RDOT") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDOT %i\n",n);
      m = n/52; // 4*13 ints/floats
      for (i = 0; i < m; i++) {
	// XXXX  most likely incorrect
	n = buffer_read_int(b);
	printf("REGN/RDOT/01 %i\n",n);
	f = buffer_read_float(b);
	printf("REGN/RDOT/02 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/03 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/04 %f\n",f);
	n = buffer_read_int(b);
	printf("REGN/RDOT/05 %i\n",n);
	f = buffer_read_float(b);
	printf("REGN/RDOT/06 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/07 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/08 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/09 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/10 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/11 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/12 %f\n",f);
	f = buffer_read_float(b);
	printf("REGN/RDOT/13 %f\n",f);
      }
    } else if (strcmp(s,"RDWT") == 0) {
      n = buffer_read_short(b);
      printf("REGN/RDWT %i\n",n);
      for (i = 0; i < 12; i++) {
	n = buffer_read_int(b);
	printf("%i\n",n);
      }
    } else {
      printf("Unknown chunk name\n");
      exit(-1);
    }
    free(s);
  }

  printf("End of REGN\n");

  buffer_free(b);
  b = btmp;
  buffer_setloc(b,mloc);
  buffer_skip_bytes(b,20);
  buffer_skip_bytes(b,ndata);
  if (flags1 & 0x00040000) {
    free(obuffer);
  }

#endif

  return -1;
}
