/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		zc.c - Locate zero crossings in an image.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        09 Apr 1987
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992
* COMMENT:		NEWVIP
* BY:			DH
*		
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)zc.c	3.1 7/10/92";
#endif

#include <stdio.h>
#include <stdlib.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
static IMAGE    *Zc_Image( struct struct_vip_IMAGE *);
static IMAGE    *Pos_Zc_Image( struct struct_vip_IMAGE *);
static IMAGE    *Neg_Zc_Image( struct struct_vip_IMAGE *);


#define POS_ZC 2
#define NEG_ZC 4


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: zc [in_file] [-n/-p] [-r orient_file] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "zc: %s\n", e);
    exit(1);
}


/*- Zc_Image --------------------------------------------------------

Mark zero crossings in an image.

--------------------------------------------------------------------*/

static IMAGE *Zc_Image(m)
IMAGE  *m;
{
    register int r, c;
    float  *mr;
    unsigned char *zcr;
    IMAGE  *zc;

    if (!m) {
	VIP_Error_Msg("Zc_Image: input image is NULL");
	return (NULL);
    }
    if (!(zc = ( IMAGE * ) Allocate_Image(0, 0, m->rows, m->cols, BYTETYPE))) {
	VIP_Error_Msg("Zc_Image: out of memory");
	return (NULL);
    }

    Copy_Header(m, zc);
    zc->type = BYTETYPE;
    switch (m->type) {
    case FLOATTYPE:
	for (r = m->rows - 1; r >= 0; r--) {
	    mr = m->i.f[r];
	    zcr = zc->i.c[r];

	    for (c = 1; c < m->cols - 1; c++)
		if (mr[c] < 0.0 && mr[c + 1] > 0.0) {
		    if (-mr[c] == mr[c + 1]) {
			zcr[c] = zcr[c + 1] = (int) POS_ZC;
		    }
		    else if (-mr[c] < mr[c + 1]) {
			zcr[c] = (int) POS_ZC;
		    }
		    else {
			zcr[c + 1] = (int) POS_ZC;
	            }	
		}
		else if (mr[c] > 0.0 && mr[c + 1] < 0.0) {
		    if (mr[c] == -mr[c + 1]) {
			zcr[c] = zcr[c + 1] = (int) NEG_ZC;
		    }
		    else if (mr[c] < -mr[c + 1]) {
			zcr[c] = (int) NEG_ZC;
		    }
                    else {
			zcr[c + 1] = (int) NEG_ZC;
		    }
		}
		else if (mr[c] == 0.0) {
		    if (mr[c - 1] > 0.0 && mr[c + 1] < 0.0) {
			zcr[c] = (int) NEG_ZC;
		    }
		    else if (mr[c - 1] < 0.0 && mr[c + 1] > 0.0) {
			zcr[c] = (int) POS_ZC;
		    }
		}
	}
	break;
    default:
	VIP_Error_Msg("Zc_Image: only able to process images of FLOATTYPE");
	Free_Image(zc);
	zc = NULL;
    }

    return (zc);
}


/*- Pos_Zc_Image ----------------------------------------------------

Mark zero crossings in an image.

--------------------------------------------------------------------*/

static IMAGE *Pos_Zc_Image(m)
IMAGE  *m;
{
    register int r, c;
    IMAGE  *zc;

    if (!m) {
	VIP_Error_Msg("Pos_Zc_Image: input image is NULL");
	return (NULL);
    }
    if (!(zc = ( IMAGE * ) Allocate_Image(0, 0, m->rows, m->cols, BYTETYPE))) {
	VIP_Error_Msg("Pos_Zc_Image: out of memory");
	return (NULL);
    }

    Copy_Header(m, zc);
    zc->type = BYTETYPE;
    switch (m->type) {
    case FLOATTYPE:
	for (r = 1; r < m->rows - 1; r++)
	    for (c = 1; c < m->cols - 1; c++)
		if (m->i.f[r][c] < 0.0 && m->i.f[r - 1][c + 1] > 0.0) {
		    if (-m->i.f[r][c] == m->i.f[r - 1][c + 1])
			zc->i.c[r][c] = zc->i.c[r - 1][c + 1] = (int) POS_ZC;
		    else if (-m->i.f[r][c] < m->i.f[r - 1][c + 1])
			zc->i.c[r][c] = (int) POS_ZC;
		    else
			zc->i.c[r - 1][c + 1] = (int) POS_ZC;
		}
		else if (m->i.f[r][c] > 0.0 && m->i.f[r - 1][c + 1] < 0.0) {
		    if (m->i.f[r][c] == -m->i.f[r - 1][c + 1])
			zc->i.c[r][c] = zc->i.c[r - 1][c + 1] = (int) NEG_ZC;
		    else if (m->i.f[r][c] < -m->i.f[r][c + 1])
			zc->i.c[r][c] = (int) NEG_ZC;
		    else
			zc->i.c[r - 1][c + 1] = (int) NEG_ZC;
		}
		else if (m->i.f[r][c] == 0.0) {
		    if (m->i.f[r + 1][c - 1] > 0.0 && m->i.f[r - 1][c + 1] < 0.0)
			zc->i.c[r][c] = (int) NEG_ZC;
		    else if (m->i.f[r + 1][c - 1] < 0.0 && m->i.f[r - 1][c + 1] > 0.0)
			zc->i.c[r][c] = (int) POS_ZC;
		}

	break;
    default:
	VIP_Error_Msg("Pos_Zc_Image; only able to process images of BYTETYPE");
	Free_Image(zc);
	zc = NULL;
    }
    return (zc);
}


/*- Neg_Zc_Image ----------------------------------------------------

Mark zero crossings in an image.

--------------------------------------------------------------------*/

static IMAGE *Neg_Zc_Image(m)
IMAGE  *m;

{
    register int r, c;
    IMAGE  *zc;

    if (!m) {
	VIP_Error_Msg("Neg_Zc_Image: input image is NULL");
	return (NULL);
    }
    if (!(zc = ( IMAGE * ) Allocate_Image(0, 0, m->rows, m->cols, BYTETYPE))) {
	VIP_Error_Msg("Neg_Zc_Image: out of memory");
	return (NULL);
    }

    Copy_Header(m, zc);
    zc->type = BYTETYPE;
    switch (m->type) {
    case FLOATTYPE:
	for (r = 1; r < m->rows - 1; r++)
	    for (c = 1; c < m->cols - 1; c++)
		if (m->i.f[r][c] < 0.0 && m->i.f[r - 1][c - 1] > 0.0) {
		    if (-m->i.f[r][c] == m->i.f[r - 1][c - 1])
			zc->i.c[r][c] = zc->i.c[r - 1][c - 1] = (int) NEG_ZC;
		    else if (-m->i.f[r][c] < m->i.f[r - 1][c - 1])
			zc->i.c[r][c] = (int) NEG_ZC;
		    else
			zc->i.c[r - 1][c - 1] = (int) NEG_ZC;
		}
		else if (m->i.f[r][c] > 0.0 && m->i.f[r - 1][c - 1] < 0.0) {
		    if (m->i.f[r][c] == -m->i.f[r - 1][c - 1])
			zc->i.c[r][c] = zc->i.c[r - 1][c - 1] = (int) POS_ZC;
		    else if (m->i.f[r][c] < -m->i.f[r][c - 1])
			zc->i.c[r][c] = (int) POS_ZC;
		    else
			zc->i.c[r - 1][c - 1] = (int) POS_ZC;
		}
		else if (m->i.f[r][c] == 0.0) {
		    if (m->i.f[r + 1][c + 1] > 0.0 && m->i.f[r - 1][c - 1] < 0.0)
			zc->i.c[r][c] = (int) POS_ZC;
		    else if (m->i.f[r + 1][c + 1] < 0.0 && m->i.f[r - 1][c - 1] > 0.0)
			zc->i.c[r][c] = (int) NEG_ZC;
		}
	break;
    default:
	VIP_Error_Msg("Neg_Zc_Image: only able to process images of BYTETYPE");
	Free_Image(zc);
	zc = NULL;
    }

    return (zc);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];

{
    register int argn, neg_arg = 0, pos_arg = 0;
    char   *out_arg = NULL;
    char   *in_arg = NULL;
    IMAGE  *im, *m;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    case 'n':
		if (pos_arg)
		    Usage();
		neg_arg = argn;
		break;
	    case 'p':
		if (neg_arg)
		    Usage();
		pos_arg = argn;
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();


    if (!(m = ( IMAGE * ) Read_Image(in_arg)))
	exit(1);

    if (neg_arg) {
	if (!(im = ( IMAGE * ) Neg_Zc_Image(m)))
	    exit(1);
    }
    else if (pos_arg) {
	if (!(im = ( IMAGE * ) Pos_Zc_Image(m)))
	    exit(1);
    }
    else if (!(im = ( IMAGE * ) Zc_Image(m)))
	Pperror("vision system error in zc");

    Write_Image(im, out_arg);

    exit(0);
}
