/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		demo.c - Transpose a VIP image (similar to matrix
*				 tranpose in Linear Algebra).
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        30 August 1989
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)transpose.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
IMAGE           *Transpose_Image( struct struct_vip_IMAGE * );


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: transpose [input_file] [-o output_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "transpose: %s\n", e);
    exit(1);
}


/*- Transpose_Image -------------------------------------------------

Return the transpose of an image.

--------------------------------------------------------------------*/

IMAGE  *Transpose_Image(im)
IMAGE  *im;
{
    register int r, c;
    IMAGE  *out;

    if (!im) {
	VIP_Error_Msg("Transpose_Image: input image is NULL");
	return (NULL);
    }
    if (!(out = ( IMAGE * ) Allocate_Image(0, 0, im->cols, im->rows, im->type))) {
	VIP_Error_Msg("Transpose_Image: out of memory");
	return (NULL);
    }
    Copy_Header(im, out);
    out->cols = im->rows;
    out->rows = im->cols;
    switch (im->type) {
    case BYTETYPE:
	for (r = out->rows - 1; r >= 0; r--)
	    for (c = out->cols - 1; c >= 0; c--)
		out->i.c[r][c] = im->i.c[c][r];
	break;
    default: VIP_Error_Msg("Transpose_Image: only able to process images of BYTETYPE");
	Free_Image(out);
	out = NULL;
    }
    return (out);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im, *out_im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	exit(1);
    out_im = ( IMAGE * ) Transpose_Image(im);
    if (out_im)
	Write_Image(out_im, out_arg);

    exit(0);
}
