/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		phase.c - Compute the phase angle of a complex image.
*				  Input: a complex image;
*				  Output: a matrix that stores the calculation
*				  atan2( I(u,v) / R(u,v) )
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        27 Sep 1988
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)phase.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"
#include "phasefn.h"



/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: phase [in_file] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "phase: %s\n", e);
    exit(1);
}


/*- Get_Phase_Image -------------------------------------------------

Return the phase angle of a complex image.

--------------------------------------------------------------------*/

IMAGE  *Get_Phase_Image(cim)
IMAGE  *cim;
{
    static int r, c;
    COMPLEX *cp;
    float *mp;
    float *mptop;
    IMAGE  *mat;
    int	   x;


    if (!(mat = ( IMAGE * ) Allocate_Image(0, 0, cim->rows, cim->cols, FLOATTYPE))) {
	VIP_Error_Msg("Get_Phase_Image: out of memory");
	return (NULL);
    }
    Copy_Header(cim, mat);
    mat->type = FLOATTYPE;

    for (x=0; x<cim->cols; x++) {
        mp = (float *) calloc(1, sizeof(float));
 	mp++;
    }
    
    mptop=mp;

    switch (cim->type) {
    case COMPLEXTYPE:
	for (r = cim->rows - 1; r >= 0; r--) {
	    cp = cim->i.cx[r];
	    mat->i.f[r] = (float * ) mp;
            mp=mptop;
	    for (c = cim->cols - 1; c >= 0; c--, cp--, mp--) {
		if (cp->r == 0.0 && cp->i == 0.0) {
		    /* atan2 returns undefined result */
		    *mp = 0.0;
		}
		else {
		    *mp = ( float ) (atan2((double) cp->i, (double) cp->r));
		}
	    }
	}
	break;
    default:
	VIP_Error_Msg("Get_Phase_Image: only able to process images of COMPLEXTYPE");
	Free_Image(mat);
	mat = NULL;
    }
    return (mat);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    char   *complex_arg = NULL;	/* input image file name */
    char   *matrix_arg = NULL;	/* output image file name */
    IMAGE  *cimage;		/* input image */
    IMAGE  *mat;		/* output image */

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    matrix_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!complex_arg)
	    complex_arg = argv[argn];
	else
	    Usage();


    if (!(cimage = ( IMAGE * ) Read_Image(complex_arg)))
	exit(1);

    mat = ( IMAGE * ) Get_Phase_Image(cimage);

    if (mat)
	Write_Image(mat, matrix_arg);

    exit(0);
}
