/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		mag.c - Return the pixel-wise magnitude of a
*			        COMPLEXTYPE image. (Imported from an older
*			        version of V.I.P.
* REVISION:             3.1
* AUTHOR:		DH               
* CREATION DATE:        Sept 1988
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)mag.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"


/*- Usage -----------------------------------------------------------

Print usage message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "Usage: mag [input_file] [-o output_file]\n");
    exit(1);
}


/*- Main Program ----------------------------------------------------

Return the pixel-wise amplitude of a COMPLEXTYPE image.
The output is an image of FLOATTYPE.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im = NULL, *outim = NULL;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	exit(1);

    outim = ( IMAGE * ) Complex2Float_Image(im);
    if (outim)
	Write_Image(outim, out_arg);

    Free_Image(im);
    Free_Image(outim);

    exit(0);
}
