/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		histogram.c - Produce histogram file of an image.
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        14 Sep 1987
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	22 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)histogram.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"
#include "misc.h"

void            Usage();
void            Pperror( char * );


/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: histogram [in_file] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "histogram: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int i;
    int    *sum1, *sum2, *sum3;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im = NULL;
    FILE   *fp = stdout;

    for (i = 1; i < argc; i++)
	if (argv[i][0] == '-')
	    switch (argv[i][1]) {
	    case 'o':
		if (++i < argc)
		    out_arg = argv[i];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[i];
	else
	    Usage();


    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	Pperror("main: Read_Image returns NULL");

    sum1 = (int *) malloc(sizeof(int) * 256);
    sum2 = (int *) malloc(sizeof(int) * 256);
    sum3 = (int *) malloc(sizeof(int) * 256);
    if (!sum1 || !sum2 || !sum3)
	Pperror("main: out of memory");

    if (Image_Count(im, sum1, sum2, sum3) == OK) {
	if (out_arg) {
	    fp = fopen(out_arg, "w");
	    if (fp == NULL)
		Pperror("error opening output file");
	}

	(void) fputc('\n', fp);
	for (i = 0; i < 256; i++)
	    (void) fprintf(fp, "%d %ld\n", i, sum1[i]);
	(void) fputc('\n', fp);

	switch (im->type) {
	case RGBTYPE:
	case HSITYPE:
	    for (i = 0; i < 256; i++)
		(void) fprintf(fp, "%d %ld\n", i, sum2[i]);
	    (void) fputc('\n', fp);
	    for (i = 0; i < 256; i++)
		(void) fprintf(fp, "%d %ld\n", i, sum3[i]);
	    (void) fputc('\n', fp);
	    break;
	}
	( void ) fclose(fp);
    }

    exit(0);
}
