/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		gline.c - Produce a data file for the programs XGRAPH
*				  and XVGR to graph the data from some
*				  particular lines of images.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        16 Apr 1987
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	29 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)gline.c	3.1 7/10/92";
#endif




#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );



/*

Now defd. and decld. in vip.h ( Where they should be !!! ) :	

define  GRAPH_MAX  32
#define  GRAPH_MAX  32

struct GRAPH {
    int     row;
    int     nfiles;
    char   *label[GRAPH_MAX];
    char   *filename[GRAPH_MAX];
}       graph[GRAPH_MAX];

*/

/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: gline  [-r ith_row [label1 file1] [label2 file2]...] [-o outfile]\n");
    (void) fprintf(stderr, "             [-r jth_row [label1 file1] [label2 file2]...]...\n");
    (void) fprintf(stderr, "       -r ith_row: plot the intensity of the i-th row,\n");
    (void) fprintf(stderr, "          label1 file1...: a list of image files whose i-th row will be\n");
    (void) fprintf(stderr, "          extracted and plotted.  label1 is a string of characters labelled for this data set\n");
    (void) fprintf(stderr, "       -o output file name\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "gline: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn, i, j, k;
    int     ro, indx = 0, index = 0;
    char   *outfile = NULL;
    FILE   *fp;

    IMAGE  *im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    outfile = argv[argn];
		else
		    Usage();
		break;
	    case 'r':
		if (indx > 0 && graph[index].nfiles == 0)
		    Usage();
		else if (index == GRAPH_MAX - 1)
		    Pperror("Too many graphs");
		else if (++argn < argc) {
		    if (indx > index)
			index++;
		    graph[indx++].row = atoi(argv[argn]);
		}
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (indx > index) {
	    if ((i = graph[index].nfiles) == GRAPH_MAX)
		Pperror("Too many graphs");
	    graph[index].label[i] = argv[argn];
	    if (++argn < argc)
		graph[index].filename[i] = argv[argn];
	    else
		Usage();
	    graph[index].nfiles++;
	}
	else
	    Usage();


    if (outfile) {
	fp = fopen(outfile, "w");
	if (fp == NULL)
	    Pperror("Fail to open output file");
    }
    else
	fp = stdout;

    for (i = 0; i < indx; i++)
	for (j = 0; j < graph[i].nfiles; j++) {
	    if (!(im = ( IMAGE * ) Read_Image(graph[i].filename[j])))
		exit(1);
	    /* extract the row specified */
	    if ((ro = graph[i].row) < 0 || graph[i].row >= im->rows)
		Pperror("Row number out of range");
	    else {
		(void) fprintf(fp, "\n");
		(void) fprintf(fp, "\"%s\"\n", graph[i].label[j]);
		switch (im->type) {
		case BYTETYPE:
		    for (k = 0; k < im->cols; k++)
			(void) fprintf(fp, "%d %d\n", k, im->i.c[ro][k]);
		    break;
		case SHORTTYPE:
		    for (k = 0; k < im->cols; k++)
			(void) fprintf(fp, "%d %d\n", k, im->i.s[ro][k]);
		    break;
		case LONGTYPE:
		    for (k = 0; k < im->cols; k++)
			(void) fprintf(fp, "%d %ld\n", k, im->i.l[ro][k]);
		    break;
		case FLOATTYPE:
		    for (k = 0; k < im->cols; k++)
			(void) fprintf(fp, "%d %f\n", k, im->i.f[ro][k]);
		    break;
		case DOUBLETYPE:
		    for (k = 0; k < im->cols; k++)
			(void) fprintf(fp, "%d %lf\n", k, im->i.d[ro][k]);
		    break;
		default:
		    Pperror("Can only process images of type BYTETYPE, SHORTTYPE, LONGTYPE, FLOATTYPE, and DOUBLETYPE");
		}
	    }
	}
    exit(0);
}
