/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		conj.c - Return the complex conjugate of a COMPLEXTYPE 
*				 image.
* REVISION:             3.1
* AUTHOR:               DH
* CREATION DATE:        27 Sep 1988
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	18 Feb 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)conj.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void Usage();

/*- Usage -----------------------------------------------------------

Print error message and exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: conj [complex_image_file] [-o output_complex_file]\n");
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    char   *input_arg = NULL;
    char   *output_arg = NULL;
    IMAGE  *im;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    output_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!input_arg)
	    input_arg = argv[argn];
	else
	    Usage();


    im = ( IMAGE * ) Read_Image(input_arg);

    if (im == NULL) {
	exit(1);
    }

    Image_Complex_Conjugate(im);

    Write_Image(im, output_arg);

    exit(0);
}
