/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		absim.c - Return an image whose elements are the
*				  absolute values of the corresponding
*				  elements in a given image.
* REVISION:             3.2
* AUTHOR:               DH
* CREATION DATE:        25 Nov 1988
* REVISION DATE:	4/8/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:	3.2
* DATE:		8 April 1994
* COMMENT:		Fixed compiler warnings
* BY:			BJR
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	03 Feb 1992 
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)absim.c	3.2 4/8/94";
#endif




#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <memory.h>
#include "vip.h"

void Usage();
void Pperror(char *e);

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: absim [image_file] [-o output_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "absim: %s\n", e);
    exit(1);
}


/*- Absolute_Image --------------------------------------------------

Return an image whose pixel values are the absolute values of the
corresponding pixels of an input image.

--------------------------------------------------------------------*/

IMAGE  *Absolute_Image(im)
IMAGE  *im;
{
    register int r, c;
    IMAGE  *out;

    if (!im) {
	VIP_Error_Msg("Absolute_Image: input image is NULL");
	return (NULL);
    }
    if (!(out = ( IMAGE * ) Allocate_Image(0, 0, im->rows, im->cols, im->type))) {
	VIP_Error_Msg("Absolute_Image: input image is NULL");
	return (NULL);
    }
    Copy_Header(im, out);

    switch (im->type) {
    case BYTETYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    /* no change */
	    memcpy(out->i.c[r], im->i.c[r], sizeof(unsigned char) * im->cols);
	break;
    case SHORTTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		out->i.s[r][c] = (short) fabs((double) im->i.s[r][c]);
	break;
    case LONGTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		out->i.l[r][c] = (long) fabs((double) im->i.l[r][c]);
	break;
    case FLOATTYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		out->i.f[r][c] = (float) fabs((double) im->i.f[r][c]);
	break;
    case DOUBLETYPE:
	for (r = im->rows - 1; r >= 0; r--)
	    for (c = im->cols - 1; c >= 0; c--)
		out->i.d[r][c] = fabs(im->i.d[r][c]);
	break;
    default:
	VIP_Error_Msg("Absolute_Image: only able to process images of BYTETYPE, SHORTTYPE, LONGTYPE, FLOATTYPE, and DOUBLETYPE");
	Free_Image(out);
	out = NULL;
    }
    return (out);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    char   *in_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im, *out;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	exit(1);

    out = ( IMAGE * ) Absolute_Image(im);

    Write_Image(out, out_arg);

    exit(0);
}
