/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:		SPLASH            
* MODULE:		graphics.c - James' tvect.c:  2D Vector Library
*					 	      and Pixel Graphics.	
* REVISION:             3.3
* AUTHOR:		J. Trevelyan.               
* CREATION DATE:        
* REVISION DATE:	4/26/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.3
* REVISION DATE:	26 April 1994
* COMMENT:		General Maintenance
* BY:			PK
*
* REVISION:		3.2
* REVISION DATE:	16 Dec 1993
* COMMENT:		Fixed for MOTIF build
* BY:			CFF
*
* REVISION:		3.1
* REVISION DATE:	14 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:
* REVISION DATE:	November 1991
* COMMENT:		Adapted for PK's use   
* BY:			
*
*******************************************************************************/


#ifndef lint
static char *sccs_id = "@(#)graphics.c	3.3 4/26/94";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <ctype.h>
#include <math.h>

#ifdef XVIEW
#include <xview/canvas.h>
#include <xview/svrimage.h>
#include <xview/panel.h>
#include <xview/xv_xrect.h>
#include <xview/icon.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/cms.h>
#include <xview/notice.h>
#include <xview/font.h>
#else
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include "splash_motif.h"
#include "splash_motiffn.h"
#endif


#include "vip.h"
#include "graphics.h"
#include "graphicsfn.h"

/*---------- GLOBALS ----------------------------------------------*/

/* Globals for vector graphics and viewport operations  */

static int trueshape;
static int llpix, llpiy, iyofs, currentx, currenty;
static V2 llpixv, lleft, scale, pen;

/*-  SetUpColours  ------------------------------------------------*/


void     SetUpColours(colour)
#ifdef XVIEW
Xv_singlecolor colour[];	/* The colour table. */
#else
Xv_singlecolor *colour;	/* The colour table. */
#endif
{
    int      i;

    /*
     * The colour table is a structure of the form :- struct colour { int
     * red;  int green; int blue; } So we must initialize each one of them.
     * Each colour is set up by the HSLtoRGB function in terms of hue,
     * saturation and level.
     * 
     * First, set up 64 grey shades for images.  They are colour numbers 0..63.
     * Then 64 similar 'perfumed' shades for XOR draw-overs. Allow colours
     * 129..149 for specific shades. Total space is 150, leaving plenty for
     * system colours. Each colour is set up using the HSLtoRGB function.
     */

#ifdef OLDTABLE
    for (j = 40, i = 0; i < 64; j += 3, i++) {
	HSLtoRGB(180, 50, j, &colour[i]);	/* blue/green grey tones */
	HSLtoRGB(120, 255, i + 180, &colour[i + 64]);	/* green (moving) tones */
    }
#endif

    for (i = 0; i < 128; i++)
	colour[i].red = colour[i].green = colour[i].blue = 2 * i;

    colour[XORDRAW].red = 0;
    colour[XORDRAW].green = colour[XORDRAW].blue = 200;

    HSLtoRGB(0, 255, 200, &colour[RED]);	/* RED etc defined in
						 * graphics.h */
    HSLtoRGB(240, 128, 255, &colour[BLUE]);
    HSLtoRGB(120, 255, 200, &colour[GREEN]);
    HSLtoRGB(60, 255, 255, &colour[YELLOW]);
    HSLtoRGB(30, 200, 200, &colour[ORANGE]);
    HSLtoRGB(0, 100, 255, &colour[PINK]);
    HSLtoRGB(0, 0, 255, &colour[WHITE]);

    return;
}

/*- SaveDpy  ------------------------------------------------------------*/

void     SaveDpy(dpy, xwin, width, height)
Display *dpy;
Window   xwin;
int      width, height;
{
    GC       gc1 = DefaultGC(dpy, DefaultScreen(dpy));

    display = dpy;		/* global in graphics.h */
    win = xwin;
    gc = gc1;
    winwidth = width;
    winheight = height;
    return;
}

#ifdef XVIEW

/*--  DrawInto  -------------------------------------------------------

    This routine is called to draw to a selected canvas.

----------------------------------------------------------------------*/

void     DrawInto(canvas)
Canvas   canvas;		/* defines the canvas  */
{
    Xv_Window paintW;		/* canvas paint window */

    paintW = canvas_paint_window(canvas);
    display = (Display *) xv_get(paintW, XV_DISPLAY);
    gc = DefaultGC(display, DefaultScreen(display));
    winwidth = (int) xv_get(paintW, XV_WIDTH);
    winheight = (int) xv_get(paintW, XV_HEIGHT);
    win = (Window) xv_get(paintW, XV_XID);
    return;
}

#else

/*--  DrawInto2  -------------------------------------------------------

    This routine is called to draw to a selected canvas.

----------------------------------------------------------------------*/

void     DrawInto2(canvas)
Widget	canvas;		/* defines the canvas  */
{
    Window 	paintW;		/* canvas paint window */
    Arg	   	args[2];
    int		width;
    int		height;

    paintW = XtWindow(canvas);

    display = XtDisplay(canvas);

    gc = DefaultGC(display, DefaultScreen(display));

    XtSetArg(args[0], XmNwidth, &width);
    XtSetArg(args[1], XmNheight, &height);

    /*
    XtGetValues((Widget) paintW, args, 2);
    */

    XtGetValues((Widget) canvas, args, 2);

    winwidth = width;
    winheight = height;

    win = XtWindow(canvas);

    return;
}

#endif



/*--  HSLtoRGB  -------------------------------------------------------

           Colour function - convert HSL to RGB

      hue: 0..360  red=0, greeen=120, blue=240
      saturation: 0..255
      level:      0..255

      James P. Trevelyan   August 1991
      Adapted from Hearn & Baker: Computer Graphics p302

      definition   void HSLtoRGB(int, int, int, Xv_singlecolor *)

----------------------------------------------------------------------*/

void     HSLtoRGB(h, s, l, rgb)
int      h, s, l;		/* inputs - see above  */
Xv_singlecolor *rgb;		/* address of red, gree, blue array (ints) */
{
    int      seg, f, p1, p2, p3;/* working variables */

    if (h > 359)
	h = 359;
    if (h < 0)
	h = 0;
    seg = h / 60;		/* segment number 0..5 */
    f = h - 60 * seg;		/* inter - hue value   0..59 */
    p1 = (l * (256 - s)) / 256;
    p2 = (l * (256 - (s * f) / 60)) / 256;
    p3 = (l * (256 - (s * (60 - f)) / 60)) / 256;
    switch (seg) {
    case 0:
	rgb->red = l;
	rgb->green = p3;
	rgb->blue = p1;
	break;
    case 1:
	rgb->red = p2;
	rgb->green = l;
	rgb->blue = p1;
	break;
    case 2:
	rgb->red = p1;
	rgb->green = l;
	rgb->blue = p3;
	break;
    case 3:
	rgb->red = p1;
	rgb->green = p2;
	rgb->blue = l;
	break;
    case 4:
	rgb->red = p3;
	rgb->green = p1;
	rgb->blue = l;
	break;
    case 5:
	rgb->red = l;
	rgb->green = p1;
	rgb->blue = p2;
	break;
    }
    return;
}

/*----------------------------------------------------------------------*/


/*   vector library routines
     All are called by pointers, and return actual result (vector or
     double value, depending on function).
*/


void     vadd(a, b, c)
V2      *a, *b, *c;
{
    c->x = a->x + b->x;
    c->y = a->y + b->y;
    return;
}

void     vsub(a, b, c)
V2      *a, *b, *c;
{
    c->x = a->x - b->x;
    c->y = a->y - b->y;
    return;
}

void     vsmy(a, b, c)
V2      *a;
double  *b;
V2      *c;
{
    c->x = a->x * *b;
    c->y = a->y * *b;
    return;
}

void     vpiv(a, r, b, c)
V2      *a;
double  *r;
V2      *b, *c;
{
    c->x = a->x * *r + b->x;
    c->y = a->y * *r + b->y;
    return;
}

void     vmpy(a, b, c)
V2      *a, *b, *c;
{
    c->x = a->x * b->x;
    c->y = a->y * b->y;
    return;
}

void     vdiv(a, b, c)
V2      *a, *b, *c;
{
    c->x = a->x / b->x;
    c->y = a->y / b->y;
    return;
}

double   vdot(a, b)
V2      *a, *b;
{
    double   c;

    c = (a->x * b->x + a->y * b->y);
    return (c);
}

double   vmag(a)
V2      *a;
{
    double   c;

    c = sqrt(a->x * a->x + a->y * a->y);
    return (c);
}

void     vnorm(a, c)
V2      *a, *c;
{
    double   mag, umag;

    mag = vmag(a);
    if (mag >= 1.0E-20) {
	umag = 1.0 / mag;
	vsmy(a, &umag, c);
    } else {
	c->x = 0.0;
	c->y = 0.0;
    }
    return;
}

void     vperp(a, c)
V2      *a, *c;
{
    c->x = -a->y;
    c->y = a->x;
    return;
}

void     vrot(a, theta, c)
V2      *a;
double  *theta;
V2      *c;
{
    double   s, cs;

    s = sin(*theta);
    cs = cos(*theta);
    c->x = a->x * cs - a->y * s;
    c->y = a->x * s + a->y * cs;
    return;
}

/* transform direction vector v given frame As:  c:= As v   */

void     Td(As, v, c)
F4       As;
V2      *v, *c;
{
    V2       a;

    a = *v;
    c->x = As[0][0] * a.x + As[0][1] * a.y;
    c->y = As[1][0] * a.x + As[1][1] * a.y;
    return;
}

/* inverse transform direction vector v given frame As:  c:= As(T) v   */

void     Tdi(As, v, c)
F4       As;
V2      *v, *c;
{
    V2       a;

    a = *v;
    c->x = As[0][0] * a.x + As[1][0] * a.y;
    c->y = As[0][1] * a.x + As[1][1] * a.y;
    return;
}

/* transform position vector v given frame As and origin p:  c:= As v + p  */

void     Tp(As, p, v, c)
F4       As;
V2      *v, *p, *c;
{
    V2       a, b;

    a = *v;
    b.x = As[0][0] * a.x + As[0][1] * a.y;
    b.y = As[1][0] * a.x + As[1][1] * a.y;
    c->x = b.x + p->x;
    c->y = b.y + p->y;
    return;
}

/*
 * inverse transform position vector v given frame As and origin p: 
 *  c:=  As(T)(v - p)
 */

void     Tpi(As, p, v, c)
F4       As;
V2      *v, *p, *c;
{
    V2       a;

    a.x = v->x - p->x;
    a.y = v->y - p->y;
    c->x = As[0][0] * a.x + As[1][0] * a.y;
    c->y = As[0][1] * a.x + As[1][1] * a.y;
    return;
}

/* rotate frame As by angle into frame Asnew   */

void     Frot(As, angle, Asnew)
F4       As;
double  *angle;
F4       Asnew;
{
    V2       va, vb;

    va.x = As[0][0];
    va.y = As[1][0];
    vrot(&va, angle, &vb);
    l_vperp(vb, va);
    Asnew[0][0] = vb.x;
    Asnew[1][0] = vb.y;
    Asnew[0][1] = va.x;
    Asnew[1][1] = va.y;
    return;
}


/* form frame Asnew on base vector v:  v is not normalised, but gives the  */
/* i direction     */

void     Fbase(v, Asnew)
V2      *v;
F4       Asnew;
{
    V2       va, vb;

    vnorm(v, &vb);
    l_vperp(vb, va);
    Asnew[0][0] = vb.x;
    Asnew[1][0] = vb.y;
    Asnew[0][1] = va.x;
    Asnew[1][1] = va.y;
    return;
}


/* form frame Asnew from vectors i,j  */
/* i and j must be orthogonal and normalised     */

void     FF(i, j, Asnew)
V2      *i, *j;
F4       Asnew;
{
    Asnew[0][0] = i->x;
    Asnew[1][0] = i->y;
    Asnew[0][1] = j->x;
    Asnew[1][1] = j->y;
    return;
}

void     showv(a, s)
V2      *a;
TAG      s;
{
    (void) printf("Vector: %s  [%f,%f] \n", s, a->x, a->y);
    return;
}

void     showF(As, s)
F4       As;
TAG      s;
{
    (void) printf("Frame: %s  [%f,%f] \n", s, As[0][0], As[0][1]);
    (void) printf("       %s  [%f,%f] \n", s, As[1][0], As[1][1]);
    return;
}


/*
 * --------------------------------------------------------------------------
 * ViewPort
 * 
 * Define a display area window in terms of real values xmin .. xmax and ymin ..
 * ymax.  Y increases upwards (in contrast to pixel coordinates )
 * 
 */
void     ViewPort(xmin, ymin, xmax, ymax)
double   xmin, ymin, xmax, ymax;
{
    int      urpix, urpiy;

    llpix = 0;
    llpiy = winheight;
    urpix = winwidth;
    urpiy = 0;
    l_vset(xmin, ymin, lleft);
    l_vset(llpix, llpiy, llpixv);
    iyofs = llpiy - urpiy;

    scale.x = (urpix - llpix) / (xmax - xmin);
    if (trueshape == 0) {
	scale.y = (urpiy - llpiy) / (ymax - ymin);
    } else {
	scale.y = -scale.x;
    }
    l_vset(0.0, 0.0, pen);
    Mvabs(&pen);
    return;
}

/* Change drawing colour  */
void     Colour(i)
int      i;
{
    XSetForeground(display, gc, colour_table[i]);
    return;
}

/* Move absolute    */

void     Mabs(a, b)
double   a, b;
{
    V2       vv;

    l_vset(a, b, vv);
    Mvabs(&vv);
    return;
}

void     Mvabs(v)
V2      *v;
{
    V2       vv;
    int      ix, iy;

    pen = *v;
    vv.x = (pen.x - lleft.x) * scale.x;
    vv.y = (pen.y - lleft.y) * scale.y;
    ix = vv.x;
    iy = vv.y;
    currentx = ix;
    currenty = iy + iyofs;
    return;
}


void     Mkvabs(v, code)	/* Display a square blob (1), or a hollow
				 * square (2) */
V2      *v;
int      code;
{
    V2       vv;
    int      ix, iy;

    pen = *v;
    vv.x = (pen.x - lleft.x) * scale.x;
    vv.y = (pen.y - lleft.y) * scale.y;
    ix = vv.x;
    iy = vv.y + iyofs;
    switch (code) {
    case 1:
	XFillRectangle(display, win, gc, ix - 1, iy - 1, 2, 2);
	break;
    case 2:
	XDrawRectangle(display, win, gc, ix - 1, iy - 1, 2, 2);
	break;
    case 3:
	XDrawRectangle(display, win, gc, ix - 2, iy - 2, 4, 4);
	break;
    default:
	break;
    };
    return;
}

/* Move relative    */

void     Mrel(a, b)
double   a, b;
{
    V2       vv;

    l_vset(a, b, vv);
    Mvrel(&vv);
    return;
}

void     Mvrel(v)
V2      *v;
{
    V2       vv;

    vadd(v, &pen, &vv);
    Mvabs(&vv);
    return;
}


/* Line absolute    */

void     Labs(a, b)
double   a, b;
{
    V2       vv;

    l_vset(a, b, vv);
    Lvabs(&vv);
    return;
}

void     Lvabs(v)
V2      *v;
{
    V2       vv;
    int      ix, iy;

    pen = *v;
    vv.x = (pen.x - lleft.x) * scale.x;
    vv.y = (pen.y - lleft.y) * scale.y;
    ix = vv.x;
    iy = vv.y;
    iy += iyofs;
    XDrawLine(display, win, gc, currentx, currenty, ix, iy);
    currentx = ix;
    currenty = iy;
    return;
}

/* Line relative    */

void     Lrel(a, b)
double   a, b;
{
    V2       vv;

    l_vset(a, b, vv);
    Lvrel(&vv);
    return;
}

void     Lvrel(v)
V2      *v;
{
    V2       vv;

    vadd(v, &pen, &vv);
    Lvabs(&vv);
    return;
}

/* Convert point (integer) coordinates to vector  */


void     InvsxI(ix, iy, v)
int      ix, iy;
V2      *v;
{
    V2       vv;

    vv.x = ix - llpix;
    vv.y = iy - llpiy;
    vdiv(&vv, &scale, &vv);
    vadd(&vv, &lleft, v);
    return;
}


/*- Graph  --------------------------------------------------------------

Simple function to plot a graph into the current canvas

------------------------------------------------------------------------*/

int Graph(data,npts,xmin,xmax,xstep,ymin,ymax,ystep,title)
double data[];
int npts;
double xmin,xmax,xstep,ymin,ymax,ystep;
char *title;
{
double xrange,yrange,xinc;
int i,xsteps,ysteps;
V2 v0,v1,v2;
char number[20];


xrange = xmax-xmin;
yrange = ymax-ymin;
xsteps = xrange/xstep;
ysteps = yrange/ystep;
xinc = xrange/(double)npts;

    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, colour_table[WHITE]);
    XFillRectangle(display, win, gc, 0, 0, 512, 256);	/* clear previous text */

    XSetForeground(display, gc, colour_table[BLACK]);
    XDrawString(display, win, gc, 10, 12, title, strlen(title));

ViewPort(xmin-.2*xrange,ymin-0.2*yrange,xmax+0.2*xrange,ymax+0.2*yrange);

/* draw axes */

Mabs(xmin,ymin);
Labs(xmin,ymax);
Mabs(xmin,ymin);
Labs(xmax,ymin);

/* draw ticks */

InvsxI(10,10,&v0);
InvsxI(10,15,&v1);
vsub(&v1,&v0,&v2);
for(i = 0; i <= xsteps; i++) {
  Mabs((double)i*xstep+xmin,ymin);
  Lvrel(&v2);

  (void) sprintf(number,"%5.1f",(double)i*xstep+xmin);

  XDrawString(display, win, gc, currentx, currenty+10, number, strlen(number));

}


InvsxI(5,10,&v1);
vsub(&v1,&v0,&v2);
for(i = 0; i <= ysteps; i++) {
  Mabs(xmin,(double)i*ystep+ymin);
  Lvrel(&v2);
  (void) sprintf(number,"%5.1f",(double)i*ystep+ymin);
  XDrawString(display, win, gc, 10, currenty+5, number, strlen(number));
}


/* plot the data */

    Mabs(xmin, data[0]);
    for (i = 1; i < npts; i++)
	Labs(xmin + (double) i*xinc, data[i]);


return(1);
}














