/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            LIB
* MODULE:	        oldvip.c - Functions to read old V.I.P. images.		
* REVISION:             3.3
* AUTHOR:		CA/DH               
* CREATION DATE:	24 Sept 1991        
* REVISION DATE:	8/16/93        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION NO:		3.4
* REVISION DATE:	15 Sept 1993
* COMMENT:		Fixed up for GENERIC build
* BY:			CFF
*
* REVISION NO:		3.3
* REVISION DATE:	16 August 1993
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION NO:		3.2
* REVISION DATE:	26 July 1993
* COMMENT:		Fixed bug in old_init_image
* BY:			CFF
*
* REVISION NO:		3.1
* REVISION DATE:	9 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)oldvip.c	3.3 8/16/93";
#endif

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef DOS
#include <fcntl.h>
#include <sys\stat.h>
#include <string.h>
#include <mem.h>
#include "pcvip.h"
#else
#include <malloc.h>
#include "vip.h"
#include "vipiofn.h"
#include <sys/file.h>
#endif

#include "oldvip.h"
#include "oldvipfn.h"

#define BUFFER_LENGTH   128

#ifdef DOS
extern char *malloc();
#endif


/*- old_read_id------------------------------------------------------

Function to return a file handler and an old V.I.P. magic number.

--------------------------------------------------------------------*/

int     old_read_id(filename, handle)
char   *filename;
int    *handle;
{
    int     file_id = -1;
    char    buffer[6];
    int     hand = 0;
    char    IM[200], buf[200];
    int     length;

    if (filename) {

#ifdef DOS 
	if ((hand = open(filename, O_BINARY | O_RDONLY, 0444)) == -1)
	    return (file_id);
#else
	if ((hand = open(filename, O_RDONLY, 0444)) == -1) {

	    (void) sprintf(buf, "old_read_id: fail to open input file %s.",
		    filename);
	    VIP_Error_Msg(buf);
	    return -1;
	}
#endif
    }

#ifdef DOS
    else
	setmode(hand, O_BINARY);/* text to bin */
#endif

    read(hand, buffer, 5);
    buffer[6] = '\0';
    (void) sscanf(buffer, "%d", &file_id);

    *handle = hand;

    return (file_id);
}


/*- old_init_image --------------------------------------------------

Function to initialize all pixels of an image to 0.

--------------------------------------------------------------------*/

old_image old_init_image(im)
old_image im;
{
    register int r;

    if (!im)
	return (NULL);

    for (r = 0; r < im->nr; r++)

#ifdef U_NIX /* UNIX is a resvd gcc macro - CFF */
	bzero(im->i[r], im->nc);
#else
	(void) memset(im->i[r], (int) 0, im->nc);
#endif

    return (im);
}


/*- old_new_image ---------------------------------------------------

Function to allocate space for an old V.I.P. image.
nr and nc are the number of rows and columns of the image respectively.

--------------------------------------------------------------------*/

old_image old_new_image(nr, nc)
int     nr, nc;
{
    old_image im;
    register int r, rt;

    if ((nr < 1) || (nc < 1))
	return (NULL);

    if ((im = (old_image) malloc(sizeof(struct old_image_struct))) == NULL)
	return (NULL);

    im->nc = nc;
    im->nr = nr;
    im->res = 0;
    im->den = 0.0;
    im->omega = 0;
    im->fnr = 0;
    im->fnc = 0;
    im->sint = 0;
    im->sfloat = 0.0;

    im->i = (unsigned char **) malloc(nr * sizeof(unsigned char *));
    if (!im->i) {
	(void) free(im);
	return (NULL);
    }
    for (r = 0; r < nr; r++) {
	im->i[r] = (unsigned char *) malloc(nc);
	if (!im->i[r]) {
	    for (rt = 0; rt < r; rt++)
		free(im->i[rt]);
	    free(im->i);
	    free(im);
	    return (NULL);
	}
    }
    return (old_init_image(im));
/*
    return (im);
*/
}


/*- old_free_image --------------------------------------------------

Function to deallocate space for an old V.I.P. image.

--------------------------------------------------------------------*/

int     old_free_image(im)
old_image im;
{
    register int r;

    if (!im)
	return (0);

    for (r = 0; r < im->nr; r++)
	free(im->i[r]);
    free(im->i);
    free(im);

    return (1);
}


/*- old_read_image --------------------------------------------------

Function to read in an old V.I.P. image from disk.

--------------------------------------------------------------------*/

old_image old_read_image(handle)
int     handle;
{
    register int r;
    int     nc, nr, res, sint;
    int     omega, fnr, fnc;
    float   den, sfloat;
    old_image im;
    char    buffer[BUFFER_LENGTH];

    for (r = 0; r < BUFFER_LENGTH; r++) {
	read(handle, buffer + r, 1);
	if (buffer[r] == '\n')
	    break;
    }
    (void) sscanf(buffer, "%d %d %d %f %d %d %d %d %f",
	   &nr, &nc, &res, &den, &omega, &fnr, &fnc, &sint, &sfloat);

    if ((im = old_new_image(nr, nc)) == NULL) {
	if (handle)
	    close(handle);

#ifdef DOS
	else
	    setmode(handle, O_TEXT);	/* bin to text */
#endif

	return (NULL);
    }
    im->res = res;
    im->den = den;
    im->omega = omega;
    im->fnr = fnr;
    im->fnc = fnc;
    im->sint = sint;
    im->sfloat = sfloat;

    for (r = 0; r < nr; r++) {
	(void) read(handle, im->i[r], nc);
    }

    if (handle)
	close(handle);

#ifdef DOS
    else
	setmode(handle, O_TEXT);/* bin to text */
#endif

    return (im);
}


/*- old_init_matrix -------------------------------------------------

Function to initialize an old V.I.P. float image..

--------------------------------------------------------------------*/

old_matrix old_init_matrix(m)
old_matrix m;
{
    register int r;

    if (!m)
	return (NULL);

    for (r = 0; r < m->nr; r++)

#ifdef DOS 
	(void) memset(m->m[r], 0, sizeof(float) * m->nc);
#else
	bzero(m->m[r], sizeof(float) * m->nc);
#endif

    return (m);
}


/*- old_new_matrix --------------------------------------------------

Function to allocate space for an old V.I.P. float image.

--------------------------------------------------------------------*/

old_matrix old_new_matrix(nr, nc)
int     nr, nc;
{
    old_matrix m;
    register int r, rt;

    if ((nr < 1) || (nc < 1))
	return (NULL);

    m = (old_matrix) malloc(sizeof(struct old_matrix_struct));
    if (!m)
	return (NULL);

    m->nr = nr;
    m->nc = nc;
    m->res = 0;
    m->den = 0.0;
    m->omega = 0;
    m->fnr = 0;
    m->fnc = 0;
    m->sint = 0;
    m->sfloat = 0.0;

    m->m = (float **) malloc(nr * sizeof(float *));
    if (!m->m) {
	free(m);
	return (NULL);
    }
    for (r = 0; r < nr; r++) {
	m->m[r] = (float *) malloc(nc * sizeof(float));
	if (!m->m[r]) {
	    for (rt = 0; rt < r; rt++)
		free(m->m[rt]);
	    free(m->m);
	    free(m);
	    return (NULL);
	}
    }

    return(old_init_matrix(m));
/*
    return (m);
*/
}


/*- old_free_matrix -------------------------------------------------

Function to deallocate space for an old V.I.P. float image.

--------------------------------------------------------------------*/

int     old_free_matrix(m)
old_matrix m;
{
    register int r;

    if (!m)
	return (0);

    for (r = 0; r < m->nr; r++)
	free(m->m[r]);
    free(m->m);
    free(m);

    return (1);
}


/*- old_read_matrix -------------------------------------------------

Function to read in an old V.I.P. float image from disk.

--------------------------------------------------------------------*/

old_matrix old_read_matrix(handle)
int     handle;
{
    register int r;
    int     nc, nr, res, sint;
    int     omega, fnr, fnc;
    float   den, sfloat;
    old_matrix m;
    char    buffer[BUFFER_LENGTH];

    for (r = 0; r < BUFFER_LENGTH; r++) {
	read(handle, buffer + r, 1);
	if (buffer[r] == '\n')
	    break;
    }
    (void) sscanf(buffer, "%d %d %d %f %d %d %d %d %f",
	   &nr, &nc, &res, &den, &omega, &fnr, &fnc, &sint, &sfloat);

    if ((m = old_new_matrix(nr, nc)) == NULL) {
	if (handle)
	    close(handle);
	return (NULL);
    }
    m->res = res;
    m->den = den;
    m->omega = omega;
    m->fnr = fnr;
    m->fnc = fnc;
    m->sint = sint;
    m->sfloat = sfloat;

    for (r = 0; r < nr; r++)
	read(handle, m->m[r], nc * sizeof(float));

    if (handle)
	close(handle);

    return (m);
}


/*- old_init_cpimage ------------------------------------------------

Function to read in an old V.I.P. float image from disk.

--------------------------------------------------------------------*/


old_cp_image old_init_cpimage(m)
old_cp_image m;

/* Initialize complex iamge m. */
{
    register int r;

    if (!m)
	return (NULL);

    for (r = 0; r < m->nr; r++)

#ifdef DOS
        (void) memset(m->c[r], (int) 0, 
		       sizeof(struct old_cp_image_struct) * m->nc);
#else
	bzero(m->c[r], sizeof(struct old_complex) * m->nc);
#endif
    return (m);
}


/*- old_new_cpimage -------------------------------------------------

Function to allocate space for an old V.I.P. complex image.

--------------------------------------------------------------------*/


old_cp_image old_new_cpimage(nr, nc)
int     nr, nc;

/* Allocate storage for a new complex image of size nr X nc. */
{
    old_cp_image m;
    register int r, rt;

    if ((nr < 1) || (nc < 1))
	return (NULL);

    m = (old_cp_image) malloc(sizeof(struct old_cp_image_struct));
    if (!m)
	return (NULL);

    m->nr = nr;
    m->nc = nc;
    m->res = 0;
    m->den = 0.0;
    m->omega = 0;
    m->fnr = 0;
    m->fnc = 0;
    m->sint = 0;
    m->sfloat = 0.0;

    m->c = (struct old_complex **) malloc(nr * sizeof(struct old_complex *));
    if (!m->c) {
	free(m);
	return (NULL);
    }
    for (r = 0; r < nr; r++) {
	m->c[r] = (struct old_complex *) malloc(nc * sizeof(struct old_complex));
	if (!m->c[r]) {
	    for (rt = 0; rt < r; rt++)
		free(m->c[rt]);
	    free(m->c);
	    free(m);
	    return (NULL);
	}
    }

    return (old_init_cpimage(m));
/*
    return (m);
*/
}


/*- old_free_cpimage ------------------------------------------------

Function to deallocate space for an old V.I.P. complex image.

--------------------------------------------------------------------*/


int     old_free_cpimage(m)
old_cp_image m;

/* Deallocate complex image m . */
{
    register int r;

    if (!m)
	return (0);

    for (r = 0; r < m->nr; r++)
	free(m->c[r]);
    free(m->c);
    free(m);

    return (1);
}


/*- old_read_cpimage ------------------------------------------------

Function to read in an old V.I.P. complex image from disk.

--------------------------------------------------------------------*/


old_cp_image old_read_cpimage(handle)
int     handle;

/* Read a complex from file descriptor handle. */
{
    register int r;
    int     nc, nr, res, sint;
    int     omega, fnr, fnc;
    float   den, sfloat;
    old_cp_image m;
    char    buffer[BUFFER_LENGTH];

    /* Read the file hander */
    for (r = 0; r < BUFFER_LENGTH; r++) {
	read(handle, buffer + r, 1);
	if (buffer[r] == '\n')
	    break;
    }
    (void) sscanf(buffer, "%d %d %d %f %d %d %d %d %f",
	   &nr, &nc, &res, &den, &omega, &fnr, &fnc, &sint, &sfloat);

    if ((m = old_new_cpimage(nr, nc)) == NULL) {
	if (handle)
	    close(handle);
	return (NULL);
    }
    m->res = res;
    m->den = den;
    m->omega = omega;
    m->fnr = fnr;
    m->fnc = fnc;
    m->sint = sint;
    m->sfloat = sfloat;

    for (r = 0; r < nr; r++)
	read(handle, m->c[r], nc * sizeof(struct old_complex));

    if (handle)
	close(handle);

    return (m);
}


/*- Convert_Image ---------------------------------------------------

Function to convert an old V.I.P. image to a new V.I.P. image.

--------------------------------------------------------------------*/

IMAGE  *Convert_Image(oldim)
old_image oldim;
{
    register int r;
    struct struct_vip_IMAGE  *im;

    if (!oldim)
	return NULL;

    im = ( IMAGE * )  Allocate_Image(0, 0, oldim->nr, oldim->nc, BYTETYPE);

    for (r = 0; r < oldim->nr; r++)

#ifdef DOS
	memcpy(im->i.c[r], oldim->i[r], oldim->nc);
#else
	bcopy(oldim->i[r], im->i.c[r], oldim->nc);
#endif

    return im;
}


/*- Convert_Matrix --------------------------------------------------

Function to convert an old V.I.P. float image to a new V.I.P. image.

--------------------------------------------------------------------*/

IMAGE  *Convert_Matrix(oldmat)
old_matrix oldmat;
{
    register int r;
    IMAGE  *im;

    if (!oldmat)
	return NULL;

    im = ( IMAGE * ) Allocate_Image(0, 0, oldmat->nr, oldmat->nc, FLOATTYPE);
    for (r = 0; r < oldmat->nr; r++)

#ifdef DOS
	memcpy(im->i.f[r], oldmat->m[r], oldmat->nc * sizeof(float));
#else
	bcopy(oldmat->m[r], im->i.f[r], oldmat->nc * sizeof(float));
#endif

    return im;
}


/*- Convert_Complex_Image -------------------------------------------

Function to convert an old V.I.P. complex image to a new V.I.P. image.

--------------------------------------------------------------------*/

IMAGE  *Convert_Complex_Image(oldcpim)
old_cp_image oldcpim;
{
    register int r;
    IMAGE  *im;

    if (!oldcpim)
	return NULL;

    im = ( IMAGE * ) Allocate_Image(0, 0, oldcpim->nr, oldcpim->nc, COMPLEXTYPE);
    for (r = 0; r < oldcpim->nr; r++)

#ifdef DOS
	memcpy(im->i.f[r], oldcpim->c[r], oldcpim->nc * sizeof(COMPLEX));
#else
	bcopy(oldcpim->c[r], im->i.f[r], oldcpim->nc * sizeof(COMPLEX));
#endif

    return im;
}

