/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		vipspatfn.h - ANSI Fn. Prototypes for
* REVISION:             3.4
* AUTHOR:               CFF
* CREATION DATE:        10 July 1992
* REVISION DATE:	4/15/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.4
* CREATION DATE:        14 April 1994
* COMMENT:		Added Add_Image.
* BY:			PK
*
* REVISION:             3.3
* CREATION DATE:        5 April 1994
* COMMENT:		Modified prototype for Float_Mask2Image.
                        Added FConvolve_Image.
* BY:			PK
*
* REVISION:             3.2
* CREATION DATE:        03 March 1994
* COMMENT:		Added prototypes from PK's binotransfn.h and __vip_h
* BY:			CFF
*
* REVISION:             3.1
* CREATION DATE:        10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* @(#)vipspatfn.h	3.4 4/15/94
*
*******************************************************************************/

#ifndef __vip_h
int     Histogram_Image(struct struct_vip_IMAGE *, int[]);

int     Image_Min_Max(IMAGE *im, double *min1, double *max1, double *min2, 
        double *max2, double *min3, double *max3);
IMAGE  *Thresh_Image(struct struct_vip_IMAGE *, int);
IMAGE  *Floor_Thresh_Image(struct struct_vip_IMAGE *, int);
IMAGE  *Ceiling_Thresh_Image(struct struct_vip_IMAGE *, int);
IMAGE  *Gaussian_2D(int);
IMAGE  *Gaussian_1D(int);
IMAGE  *Laplacian_Gaussian_2D(int);
IMAGE  *Laplacian_Gaussian_1D(int);
IMAGE  *Logarithmic_Transform_Image(struct struct_vip_IMAGE *);
IMAGE  *Convolve_Image(struct struct_vip_IMAGE *, struct struct_vip_INT_MASK *);
IMAGE  *Average_Image(struct struct_vip_IMAGE *, struct struct_vip_IMAGE *);
IMAGE  *Diff_Image(struct struct_vip_IMAGE *,
            struct struct_vip_IMAGE *, int);
IMAGE  *Subtract_Image(struct struct_vip_IMAGE *,
            struct struct_vip_IMAGE *, int, int);
IMAGE  *Add_Image(struct struct_vip_IMAGE *, struct struct_vip_IMAGE *);
IMAGE  *Scale_Image(struct struct_vip_IMAGE *, double);
IMAGE  *Offset_Image(struct struct_vip_IMAGE *, double);
IMAGE  *DeRes_Image(struct struct_vip_IMAGE *, int);
IMAGE  *Res_Image(struct struct_vip_IMAGE *, int, int);
IMAGE  *Sqrt_Image(struct struct_vip_IMAGE *);
IMAGE  *Sqr_Image(struct struct_vip_IMAGE *);
IMAGE  *Knn_Image(struct struct_vip_IMAGE *, int, int);
IMAGE  *Snn_Image(struct struct_vip_IMAGE *, int);
IMAGE  *Clip_Image(struct struct_vip_IMAGE *, int, int, int,
            int);
IMAGE  *Image_Row_Reflect(struct struct_vip_IMAGE *);
IMAGE  *Image_Column_Reflect(struct struct_vip_IMAGE *);
int     Find_Spot(struct struct_vip_IMAGE *, int, int, int, int,
            int, int, int *, int *);
int     Wind_Int(struct struct_vip_IMAGE *, int, int, int, int,
            int *);
INT_MASK *Allocate_Int_Mask(int, int);
void    Free_Int_Mask(struct struct_vip_INT_MASK *);
INT_MASK *Read_Int_Mask(char *);
int     Write_Int_Mask(struct struct_vip_INT_MASK *, char *,
            char *);
int     Read_Energy_Filter(char *, float **, float **, int *);
IMAGE  *Apply_Local_Energy(struct struct_vip_IMAGE *, float *,
            float *, int, double);
IMAGE  *Erode_Image(struct struct_vip_IMAGE *,
            struct struct_vip_INT_MASK *);
IMAGE  *Dilate_Image(struct struct_vip_IMAGE *,
            struct struct_vip_INT_MASK *);
int     get_pixel_B(IMAGE *, int, int);

IMAGE *Distance_Transform(IMAGE *inimage);





FLOAT_MASK *Rotate_Float_Mask(FLOAT_MASK * mask, double angle);
void    Scale_Float_Mask(FLOAT_MASK * mask, float scale);
struct struct_vip_IMAGE *Float_Mask2Image(FLOAT_MASK * mask, int rows, int cols, int shift);
struct struct_vip_IMAGE *Rotate_Image(struct struct_vip_IMAGE * inimage, double angle);
struct struct_vip_IMAGE *XYScale_Image(struct struct_vip_IMAGE * image, float xscale, float yscale);
double  Bilinear_Interpolate(struct struct_vip_IMAGE * image, double x, double y);
void    Free_Float_Mask(FLOAT_MASK * mask);
FLOAT_MASK *Allocate_Float_Mask(int rows, int cols);
float   Instantaneous_Freq(float A[], int x, FLOAT_MASK * sinmask[], FLOAT_MASK * cosmask[], int nfreq, int Noct, float freq[]);
int     Correlate(float A[], float B[], int n);
struct struct_vip_IMAGE *Image_Spectrum(struct struct_vip_IMAGE * inimage);
void    Image_Line(struct struct_vip_IMAGE * image, int us, int vs, int ue, int ve, int grey);
void    Image_Point(struct struct_vip_IMAGE * image, int u, int v, int size, int grey);
struct struct_vip_IMAGE *FConvolve_Image(struct struct_vip_IMAGE * image, FLOAT_MASK * mask);
float   Point_Convolve(struct struct_vip_IMAGE * image, int uc, int vc, FLOAT_MASK * mask);
void    fourn(float data[], int nn[], int ndim, int isign);
void    Accumulate_Add_Image(struct struct_vip_IMAGE * Ac, struct struct_vip_IMAGE * image);
struct struct_vip_IMAGE *Multiply_Image(struct struct_vip_IMAGE * image1, struct struct_vip_IMAGE * image2);
struct struct_vip_IMAGE *Divide_Image(struct struct_vip_IMAGE * image1, struct struct_vip_IMAGE * image2);
struct struct_vip_IMAGE *Squared_Image_Difference(struct struct_vip_IMAGE * image1, struct struct_vip_IMAGE * image2);
struct struct_vip_IMAGE *Make_Homomorphic_Filter(int rows, int cols, double CutOff,
            double LowGain, double HighGain, int order);
struct struct_vip_IMAGE *Make_Butterworth_Filter(int rows, int cols, double CutOff, int order, char *type);
int     Closest_Power_Of_2(int x);
int     Power_Of_2_Greater_Or_Equal(int x);
struct struct_vip_IMAGE *Log_Image(struct struct_vip_IMAGE * image);
struct struct_vip_IMAGE *Exp_Image(struct struct_vip_IMAGE * image);
int     Image_Mean(IMAGE *im, double *mean1, double *mean2, double *mean3);
int     Image_Mean_StdDev(struct struct_vip_IMAGE * image, double *mean, double *StdDev);
struct struct_vip_IMAGE *Truncate_Image_Histogram(struct struct_vip_IMAGE * image, int lowerpercent, int higherpercent);

#endif				/* !__vip_h */
