/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		graphics.h		
* REVISION:             3.2
* AUTHOR:               
* CREATION DATE:        
* REVISION DATE:	12/16/93        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.2
* REVISION DATE:	16 Dec 1993
* COMMENT:		Added new defs for MOTIF colours.
* BY:			CFF
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* @(#)graphics.h	3.2 12/16/93
*
*******************************************************************************/

/* Graphics Include file  ---------------------------------------- */

/*
 * Constants
 */
#define BLACK   0

#ifdef XVIEW
#define RED 	129
#else
#define RED 	255
#endif

#define GREEN 	130
#define YELLOW	133
#define ORANGE	134
#define PINK  	135
#define BLUE	131

#ifdef XVIEW
#define WHITE	132	
#else
#define WHITE   254
#endif

#define XORDRAW   136		/* XOR drawing index for moving lines */


/*
 * Structure and macro definitions
 */

/**************************************************************************

In-line vector operations.  These provide the fastest code, at the expense
of memory space.  Each translates to one or more statements. For example

V2 a,b,c;       ...........     l_vadd(a,b,c)  makes c:=a+b.

*/

#define l_vadd(A,B,C)  C.x=A.x+B.x; C.y=A.y+B.y
#define l_vsub(A,B,C)  C.x=A.x-B.x; C.y=A.y-B.y
#define l_vmpy(A,B,C)  C.x=A.x*B.x; C.y=A.y*B.y
#define l_vsmy(A,R,C)  C.x=A.x*R; C.y=A.y*R
#define l_vdiv(A,B,C)  C.x=A.x/B.x; C.y=A.y/B.y
#define l_vpiv(A,R,B,C)  C.x=A.x*R+B.x; C.y=A.y*R+B.y
#define x_vdot(A,B)  (A.x*B.x+A.y*B.y)
#define x_vcross(A,B) (A.x*B.y-A.y*B.x)
#define x_vmag(A) sqrt(A.x*A.x + A.y*A.y)
#define l_vperp(A,C)  C.x=-A.y; C.y=A.x
#define l_vset(P,Q,C)  C.x=P; C.y=Q

/************** vector (2 element) and transform (4 element) **************/

typedef double F4[2][2];	/* F4 is 4 element coord. frame */
typedef struct struct_V2 {
    double   x, y;
    int      vtyp;
}        V2;			/* 2 element vector type  */
typedef char TAG[20];		/* 20 character tag string  */


/**************************************************************************

Vector functions

... old C definitions  ..... */

/*
void     vadd();
void     vsub();
void     vmpy();
void     vdiv();
void     vsmy();
void     vpiv();
double   vdot();
void     vnorm();
double   vmag();
void     vperp();
void     vrot();

void     Td();
void     Tdi();
void     Tp();
void     Tpi();
void     showv();
void     showF();
void     inputv();
void     FF();
void     Fbase();
void     Frot();
*/

/***************************************************************************/
/* Graphics Routines and global data values   */
/* ... old C ..... */

/*
void     ViewPort();
void     StartGraphics();
void     CloseView();
void     Colour();
void     Mvabs();
void     Mkvabs();
void     Mabs();
void     Labs();
void     Mrel();
void     Lrel();
void     Lvabs();
void     Mvrel();
void     Lvrel();
*/


/* ANSI fn. prototypes now in graphicsfn.h - CFF */

/*
void     SetUpColours(); *//* sets up colour array */
/*
void     HSLtoRGB(); *//* change colour coordinates */
/*
void     SaveDpy(); *//* saves data for drawing */
/*
void     SelectCursor(); *//* select cursor */
/*
void     DrawInto(); *//* select canvas for drawing */


/* X Globals for drawing into windows */

GC       gc;
Window   win;
int      winwidth, winheight;
Display *display;		/* set up by SaveDpy routine */
unsigned long *colour_table;


/* Globals for vector graphics and viewport operations  */

static int trueshape;
static int llpix, llpiy, iyofs, currentx, currenty;
static V2 llpixv, lleft, scale, pen;

