/*
$Header: undo.h,v 1.5 93/08/30 11:01:52 hmallat Exp $
*/

#ifndef UNDO

#include "pixel.h"

struct undo_buffer{
  int resized;
  int x, y;                  /* the upper left coordinate of the picture */
  struct picture *data_p;    /* the actual data */
  struct picture *pic_p;     /* the picture where data was taken from */
  char *name_p;                /* name of the performed operation */
};

struct picture *clipboard;
struct undo_buffer *ud;
int undid;

void memorize(struct picture *pic_p, int x1, int y1, int x2, int y2,
	      struct picture *other_p, char *name);
void undo();
void clear_undo();
void delete();
void cut();
void copy();
void paste();
void paste_to_toolbox();
void paste_this(int which, int button);
struct view *duplicate();
#define UNDO
#endif
