/* FILE: misc.h

   Prototypes for miscellaneous generic functions and some generic macros.

   Written by Petri Kuittinen, last modifications 12th August 1993.
*/ 

#define ABS(X) (((X)<0)? -(X):(X)) /* get absolute value-macro, X must not have
				      any side effects! */
#define SGN(X) (((X)<0)? -1:1)     /* sign-macro, ditto as above */

#define MAX(X, Y) (((X)>(Y))? (X):(Y)) /* return greater of two args, ditto as
					  above */

#define MIN(X, Y) (((X)<(Y))? (X):(Y)) /* return smaller of two args, ditto as
					  above */

#define SWAP(X, Y) X^=Y; Y^=X; X^=Y;   /* swap two numbers, works only for
					  integers */

#define IS_EVEN(X) ((X)&1==0)          /* is X an even number */
#define IS_ODD(X) ((X)&1!=0)           /* is X an odd number */


#ifndef TRUE
#define FALSE 0
#define TRUE !(FALSE)
#endif

#define PI 3.14159265358979323846 /* approximate value of pi (20 decimals) */
#define UNDEFINED -1

/* External global variables */

extern int rnd_seed;

/* Prototypes */
void set_rnd_seed (int new_seed);
int rnd_int ();
double rnd_double ();
char *duplicate_string (char *s);

void rgb_to_hsv(double r, double g, double b, double *h, double *s, double *v);
void hsv_to_rgb(double h, double s, double v, double *r, double *g, double *b);
