/*
 X_misc.h: Miscellaneous routines used in the X/Motif module. All the X 
           specific routines that are called from the main module are in this 
	   file. 

 $Header: X_misc.h,v 2.7 93/09/03 14:46:20 wet Exp $
 */
#include <Xm/Xm.h>

#define B_OK -1
#define B_NO -2
#define B_CANCEL -3
#define B_EMPTY -4

#define DRAW_C 1
#define AIRBRUSH_C 2
#define FILL_C 3
#define SELECT_C 4
#define EXTRACT_C 5

void (*question_func)(int);
void (*error_func)(int);
void (*paste_func)(int, int);

void putimage(int x, int y, int width, int height, struct view *view_p, 
	      char *data);
void handle_resize(struct view *view_p);
void show_colors(struct view *view_p);
void show_state(char *msg);
void show_zoom(struct view *view_p);
void kill_window(struct view *view_p);

void busy(void);
void busy_nomore(void);
void view_busy(struct view *view_p);
void view_busy_nomore(struct view *view_p);
void change_cursor(struct view *view_p, int c);

void ask_question(char *text, char *ok_label, char *cancel_label, 
		  void (*func)(int));
void ask_question3(char *text, char *ok_label, char *no_label, 
		   char *cancel_label, void (*func)(int));
void show_errormsg(char *text, char *ok_label, void (*func)(int));
void ask_paste(void (*func)(int, int));

void deactivate_menu_entry(char *entry);
void activate_menu_entry(char *entry);
void change_menu_entry(char *old_entry, char *new_entry);

void center_window(Widget widget_id);

char *xs_get_string_from_xmstring(XmString string);
void get_global_bounds(Widget, unsigned int *, unsigned int *);

