/*
 * file:     plotMenu.c
 * author:   Wes Barris
 * date:     4/22/92
 * purpose:  creates File menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>

extern ICOP	icop;
extern int	haveplot;

Widget		plotType[5];

static void
PlotTypeCB(Widget w, XtPointer client_data, char *call_data)
{
   if (!((XmToggleButtonCallbackStruct *)call_data)->set)
      return;
   haveplot = 0;
   DrawPlotCB(icop.plot.w, (XtPointer)NULL, (char *)NULL);
}

static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)(Widget, XtPointer, char*);      /* callback function */
   } list[] = {
      { "ys",		PlotTypeCB},
      { "rgb",		PlotTypeCB},
      { "yiq",		PlotTypeCB},
      { "yuv",		PlotTypeCB},
      };

void
PlotMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	plotMenu, w;
/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   plotMenu = XmCreatePulldownMenu(parent, "plotMenu", arg, n);
/*
 * Create the entries for the plot menu.
 */
   for (i = 0; i < XtNumber(list); i++) {
      if (list[i].name != NULL) {
         plotType[i] = XmCreateToggleButton(plotMenu, list[i].name, arg, 0);
         XtAddCallback(plotType[i], XmNvalueChangedCallback, list[i].func, list[i].name);
         }
      else 
         plotType[i] = XmCreateSeparator(plotMenu, "sep", arg, 0);
      XtManageChild(plotType[i]);
      }
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, plotMenu); n++;
   w = XmCreateCascadeButton(parent, "plot", arg, n);
   XtManageChild(w);
}
