/*
 * file:     objectMenu.c
 * author:   Wes Barris
 * date:     5/05/92
 * purpose:  creates Object menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>

extern DESI	desi;
extern void	GetTextInfoCB();
extern void	GetImageInfoCB();
extern void	GetCmapInfoCB();

static struct {
   char	*name;		/* name of menu item widget */
   void	(*func)();	/* callback function */
   int	data;		/* callback function */
   } items[] = {
      { "text",		GetTextInfoCB,	CREATING},
      { "image",	GetImageInfoCB,	CREATING},
      { "cmap",		GetCmapInfoCB,	CREATING},
      };

void
ObjectMenuInit(parent)
Widget   parent;
{
   int		i, n;
   Arg		arg[10];
   Widget	objectMenu, w;

/*
 * Create pulldown menu.
 */
   n = 0;
   objectMenu = XmCreatePulldownMenu(parent, "objectMenu", arg, n);
/*
 * Create the entries for the file menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      w = XmCreatePushButton(objectMenu, items[i].name, arg, 0);
      XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].func, (char *)items[i].data);
      XtManageChild(w);
      }
/*
 * Create the Edit cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, objectMenu); n++;
   w = XmCreateCascadeButton(parent, "objects", arg, n);
   XtManageChild(w);
}
