/*
 * file:     grid.c
 * author:   Wes Barris
 * date:     7/10/92
 * purpose:  handles Grid panel functionality
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern UmscList	theList;
extern int	currentFrame;

static Widget	gridPanel = NULL,
		gridToggle = NULL,
		xhairToggle = NULL;


static void
GridCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	call_data;
{
   Arg			args[10];
   GenericInfo		*thisObject;
   int			n;
/*
 * Set both the grid and X-hair values.  Actually, the grid values only
 * need to be set on one selfmoving widget.  The X-hair values need to
 * be set for all.
 */
   n = 0;
   XtSetArg(args[n], XtNgrid, GetGridSize()); n++;
   XtSetArg(args[n], XtNgridOn, XmToggleButtonGetState(gridToggle)); n++;
   XtSetArg(args[n], XtNshowHorizontalLine, GetXHairToggle()); n++;
   XtSetArg(args[n], XtNshowVerticalLine, GetXHairToggle()); n++;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   while (thisObject) {
      if (thisObject->frame == currentFrame)
         XtSetValues(XtParent(thisObject->w), args, n);
      thisObject = UmscListGetNext(theList);
      }
}


/*
 * GridInit:  creates (but does not manage) Grid panel.
 */
static void
GridInit(void)
{
   int		n;
   Arg		args[10];
   Widget	rc;

   n = 0;
   gridPanel = XmCreatePromptDialog(desi.toplevel, "gridPanel", args, n);
   XtUnmanageChild(XmSelectionBoxGetChild(gridPanel, XmDIALOG_HELP_BUTTON));
   XtUnmanageChild(XmSelectionBoxGetChild(gridPanel, XmDIALOG_CANCEL_BUTTON));
   XtAddCallback(gridPanel, XmNokCallback, (XtCallbackProc)GridCB, NULL);

   n = 0;
   rc = XmCreateWorkArea(gridPanel, "rc", args, n);
   XtManageChild(rc);

   n = 0;
   gridToggle = XtCreateWidget("toggle", xmToggleButtonWidgetClass, rc, args, n);
   XtManageChild(gridToggle);

   n = 0;
   xhairToggle = XtCreateWidget("xhairToggle", xmToggleButtonWidgetClass, rc, args, n);
   XtManageChild(xhairToggle);
}


/*
 * GetXHairToggle:  returns True if X-hair is currently on; False otherwise.
 */
Boolean
GetXHairToggle(void)
{
   if (xhairToggle == NULL)
      GridInit();
   return(XmToggleButtonGetState(xhairToggle));
}


/*
 * GetGridSize:  returns the grid size.
 */
int
GetGridSize(void)
{
   char *str;
   int	i;

   if (gridPanel == NULL)
      GridInit();
   str = XmTextGetString(XmSelectionBoxGetChild(gridPanel, XmDIALOG_TEXT));
   i = atoi(str);
   free(str);
   return(i);
}

/*
 * GridPopup:  displays the grid panel.
 */
void
GridPopup(void)
{
   if (gridPanel == NULL)
      GridInit();
   XtManageChild(gridPanel);
}
