/*
 * file:     fileMenu.c
 * author:   Wes Barris
 * date:     4/22/92
 * purpose:  creates File menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include "PSutils.h"
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gl.h>
#include <gl/image.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>
#include "Umsc/List.h"

#define MAXREAD		78
#define MAXSTRLEN	80

IMAGE* iopen(char*, char*, int, int, int, int, int);
/*void cpacktorgb(unsigned long*, unsigned short*, unsigned short*, unsigned short*, long);*/
/*void putrow(IMAGE*, unsigned short*, int, int);*/
void iclose(IMAGE*);
int longstoimage(unsigned long*, int, int, int, char*);

extern DESI	desi;
extern UmscList	theList;
extern Widget	glBack;
extern int	currentFrame;
extern int	nFrames;

static Widget	ssb = NULL,
		osb = NULL,
		closeBox = NULL;

char		*filename;

int		dblsize;
int		needtosave = 0,
		dumppending = 0;
static int	quitpending;


static void
NewCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n, ntot;
/*
 * Delete any existing objects.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* how many are initially in the list */
   for (n=0; n<ntot; n++) {
      if (thisObject->frame == currentFrame) {
         XtDestroyWidget(XtParent(thisObject->w));
         }
      UmscListRemove(theList, UmscNEXT);	/* this will free object too */
      thisObject = UmscListGetCurrent(theList);
      }
   nFrames = 1;
   SetDesiTitle(NULL);
/*
 * Make the background black.
 */
   desi.back.ul[0] = desi.back.ul[1] = desi.back.ul[2] = 0;
   desi.back.ur[0] = desi.back.ur[1] = desi.back.ur[2] = 0;
   desi.back.ll[0] = desi.back.ll[1] = desi.back.ll[2] = 0;
   desi.back.lr[0] = desi.back.lr[1] = desi.back.lr[2] = 0;
   desi.back.ul[2] = desi.back.ur[2] = 40;
   desi.back.ll[2] = desi.back.lr[2] = 80;
   DrawBackCB(glBack, (XtPointer)0, (char *)0);
   needtosave = 0;
}


void
OpenDesi(char *filename)
{
   FILE		*fptr;
   GenericInfo	*thisObject;
   char		cjunk[MAXREAD], *sP, *endP, inbuf[MAXSTRLEN], *index;
   char		version[5];
   int		major_version, minor_version;
   int		nchar, done, strsize, slashatend, hiddencr;
   short	short1, short2, fxoff, fyoff;
   struct stat	buf;
/*
 * First try to find out if this is a valid desi data file.
 */
   sprintf(cjunk, "file %s", filename);
   if ((fptr = popen(cjunk, "r")) == NULL)
      fprintf(stderr, "Cannot open pipe to test file.\n");
   fread(inbuf, MAXSTRLEN, 1, fptr);
   pclose(fptr);
   if ((sP = strstr(inbuf, "SGI imagelib image")) != NULL) {
      fprintf(stderr, "%s is an SGI image file.\n", filename);
      fprintf(stderr, "Use the Image item under the Objects menu to read an SGI image file.\n");
      return;
      }
   else if ((sP = strstr(inbuf, "ascii text")) == NULL) {
      fprintf(stderr, "I don't recognize that file type.\n");
      return;
      }
   fptr = fopen(filename, "r");
/*
 * Get version number.
 */
   fscanf(fptr, "%s %s %s\n", cjunk, cjunk, version);
   major_version = atoi(&version[0]);
   minor_version = atoi(&version[2]);
/*
 * Get background information.
 */
   if (major_version == MAJOR_VERSION &&
       minor_version >= 0 && minor_version <= MINOR_VERSION) {
      nFrames = currentFrame = 1;	/* reset frame counters */
      fscanf(fptr, "%s %hd\n", cjunk, &short1);	/* width */
      fscanf(fptr, "%s %hd\n", cjunk, &short2);	/* height */
      if (short1 != desi.back.width || short2 != desi.back.height)
         UpdateBack((int)short1, (int)short2);
      fscanf(fptr, "%s %hd\n", cjunk, &fxoff);	/* desi.back.xoffset */
      fscanf(fptr, "%s %hd\n", cjunk, &fyoff);	/* desi.back.yoffset */
      fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &desi.back.ul[0],
                                              &desi.back.ul[1],
                                              &desi.back.ul[2]);
      fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &desi.back.ur[0],
                                              &desi.back.ur[1],
                                              &desi.back.ur[2]);
      fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &desi.back.ll[0],
                                              &desi.back.ll[1],
                                              &desi.back.ll[2]);
      fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &desi.back.lr[0],
                                              &desi.back.lr[1],
                                              &desi.back.lr[2]);
      DrawBackCB(glBack, (XtPointer)0, (char *)0);
      while (1)
         if (fscanf(fptr, "%s %hd\n", cjunk, &short1) != EOF) {
            if ((thisObject = (GenericInfo *)malloc(sizeof(GenericInfo))) == NULL) {
               fprintf(stderr, "ERROR -- Unable to get memory for text.\n");
               exit(1);
               }
            UmscListSetCurrent(theList, UmscLAST);
            UmscListInsert(theList, thisObject, UmscLAST);
            thisObject->objtype = short1;
            fscanf(fptr, "%s %hd\n", cjunk, &thisObject->x);
            fscanf(fptr, "%s %hd\n", cjunk, &thisObject->y);
            thisObject->x += desi.back.xoffset - fxoff;
            thisObject->y += desi.back.yoffset - fyoff;
            fscanf(fptr, "%s %d\n", cjunk, &thisObject->width);
            fscanf(fptr, "%s %d\n", cjunk, &thisObject->height);
            if (major_version == 1 && minor_version == 0)
               thisObject->frame = 1;
            else {
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->frame);
               nFrames = (thisObject->frame > nFrames ? thisObject->frame : nFrames);
               }
            if (major_version == 1 && minor_version <= 1) {
               thisObject->decoration = 0;	/* assume there is no decora */
               thisObject->dec_size = 5;	/* assume there is no decora */
               thisObject->dec[0] = 0;		/* and if there was, */
               thisObject->dec[1] = 0;		/* it would be black */
               thisObject->dec[2] = 0;
               }
            else if (major_version == 1 && minor_version == 2) {
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->dec_size);
               if (thisObject->dec_size)
                  thisObject->decoration = DROP_SHADOW;
               else {
                  thisObject->decoration = 0;
                  thisObject->dec_size = 5;
                  }
               fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &thisObject->dec[0],
                                                       &thisObject->dec[1],
                                                       &thisObject->dec[2]);
               }
            else {
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->decoration);
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->dec_size);
               fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &thisObject->dec[0],
                                                       &thisObject->dec[1],
                                                       &thisObject->dec[2]);
               }
            thisObject->selected = False;
            if (thisObject->objtype == TXTOBJ) {
               done = 0;
               strsize = 0;
               slashatend = 0;
               while (!done) {
                  fgets(cjunk, MAXREAD, fptr);
                  hiddencr = ((int)cjunk[0] == 'n' && slashatend?1:0);
/*
 * Once this condition is satisfied, I know that I have the last of the text.
 * I also have to rip off that terminating <CR> character.
 */
                  if (strlen(cjunk) != MAXREAD-1 || (int)cjunk[MAXREAD-2] == '\n') {
                     done = 1;
                     cjunk[strlen(cjunk)-1] = '\0';
                     }
                  else
                     slashatend = ((int)cjunk[MAXREAD-2] == '\\'?1:0);
/*
 * The first time thru, I need to malloc a new text array.  After that, I
 * need to use realloc to extend the size of the previously malloced array.
 */
                  if (strsize == 0) {
                     sP = strchr(cjunk, ':');
                     sP += 2;
                     strsize = strlen(sP)+1;
                     thisObject->u.text.text = (char *)malloc(strsize);
                     thisObject->u.text.text[0] = '\0';
                     }
                  else {
                     sP = cjunk;
                     strsize += strlen(sP);
                     thisObject->u.text.text = (char *)realloc(thisObject->u.text.text, strsize);
                     }
                  if (hiddencr) {
                     sP++;
                     thisObject->u.text.text[strlen(thisObject->u.text.text)-1] = '\n';
                     }
/*
 * Here I have to find all occurances of these two characers: "\n" and turn
 * them into real chariage return characters '\n'.
 */
                  endP = strstr(sP, "\\n");	/* point to first <CR> */
                  inbuf[0] = '\0';
                  while (endP) {
                     nchar = (int)(endP-sP);	/* # of chars in first str */
                     strncpy(inbuf, sP, nchar);
                     inbuf[nchar] = '\n';		/* terminate string */
                     inbuf[nchar+1] = '\0';		/* terminate string */
                     sP = endP + 2;		/* point to next str */
                     endP = strstr(sP, "\\n");	/* find next <CR> */
                     strcat(thisObject->u.text.text, inbuf);
                     }
                  strcat(thisObject->u.text.text, sP);
                  }
               fscanf(fptr, "%s %s\n", cjunk, thisObject->u.text.fontname);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.text.font);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.text.fontstyle);
               fscanf(fptr, "%s %lf\n", cjunk, &thisObject->u.text.scale);
               fscanf(fptr, "%s %hd %hd %hd\n", cjunk, &thisObject->u.text.cv[0],
                                                       &thisObject->u.text.cv[1],
                                                       &thisObject->u.text.cv[2]);
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->u.text.justify);
               if (major_version == 1 && minor_version >= 3)
                  fscanf(fptr, "%s %hd\n", cjunk, &thisObject->u.text.useShape);
               else
                  thisObject->u.text.useShape = 0;
               if (thisObject->frame == currentFrame)
                  CreateText(thisObject);
               else
                  thisObject->w = NULL;
               }
            else if (thisObject->objtype == IMGOBJ) {
               fscanf(fptr, "%s %s\n", cjunk, cjunk);
               if ((thisObject->u.image.filename = (char *)malloc(strlen(cjunk)+1)) == NULL) {
                  fprintf(stderr, "ERROR -- Unable to get memory for filename.\n");
                  exit(1);
                  }
               strcpy(thisObject->u.image.filename, cjunk);
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->u.image.keepaspect);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.image.orig_width);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.image.orig_height);
               thisObject->u.image.imgbuf = NULL;
/*
 * Clean up after the automounter.
 */
               index = strstr(thisObject->u.image.filename, "tmp_mnt");
               if (index) {
                  index += 7;
                  strcpy(inbuf, index);
                  /*free(thisObject->u.image.filename);
                  thisObject->u.image.filename = (char *)malloc(strlen(index));*/
                  strcpy(thisObject->u.image.filename, inbuf);
                  }
/*
 * Does this file really exist?
 */
               if (stat(thisObject->u.image.filename, &buf)) {
                  fprintf(stderr, "Can't find %s\n", thisObject->u.image.filename);
                  UmscListRemove(theList, UmscPREV);
                  /*free(thisObject);*/
                  }
               else
                  if (thisObject->frame == currentFrame)
                     CreateImage(thisObject);
                  else
                     thisObject->w = NULL;
               }
            else if (thisObject->objtype == MAPOBJ) {
               fscanf(fptr, "%s %s\n", cjunk, cjunk);
               if ((thisObject->u.image.filename = (char *)malloc(strlen(cjunk)+1)) == NULL) {
                  fprintf(stderr, "ERROR -- Unable to get memory for filename.\n");
                  exit(1);
                  }
               strcpy(thisObject->u.cmap.filename, cjunk);
               fscanf(fptr, "%s %hd\n", cjunk, &thisObject->u.cmap.orientation);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.cmap.orig_width);
               fscanf(fptr, "%s %d\n", cjunk, &thisObject->u.cmap.orig_height);
               thisObject->u.cmap.imgbuf = NULL;
               if (thisObject->frame == currentFrame)
                  CreateCmap(thisObject);
               else
                  thisObject->w = NULL;
               }
            }
         else
            break;
      needtosave = 0;
      sP = strrchr(filename, '/');
      SetDesiTitle(++sP);
      }
   else
      fprintf(stderr, "Invalid data file version: %s\n", version);
   fclose(fptr);
}


static void
WriteDesi(char *filename)
{
   FILE		*fptr;
   GenericInfo	*thisObject;
   char		*startP, *endP, outbuf[MAXSTRLEN], *sP;
   int		i, nchar;

   sP = strrchr(filename, '/');
   SetDesiTitle(++sP);
   fptr = fopen(filename, "w");
/*
 * Write version number.
 */
   fprintf(fptr, "Desi version: %1d.%1d\n\n", MAJOR_VERSION, MINOR_VERSION);
/*
 * Write background information.
 */
   fprintf(fptr, "BACK.width: %d\n", desi.back.width);
   fprintf(fptr, "BACK.height: %d\n", desi.back.height);
   fprintf(fptr, "BACK.xoffset: %d\n", desi.back.xoffset);
   fprintf(fptr, "BACK.yoffset: %d\n", desi.back.yoffset);
   fprintf(fptr, "BACK.ul_color: %d %d %d\n", desi.back.ul[0],
                                              desi.back.ul[1],
                                              desi.back.ul[2]);
   fprintf(fptr, "BACK.ur_color: %d %d %d\n", desi.back.ur[0],
                                              desi.back.ur[1],
                                              desi.back.ur[2]);
   fprintf(fptr, "BACK.ll_color: %d %d %d\n", desi.back.ll[0],
                                              desi.back.ll[1],
                                              desi.back.ll[2]);
   fprintf(fptr, "BACK.lr_color: %d %d %d\n", desi.back.lr[0],
                                              desi.back.lr[1],
                                              desi.back.lr[2]);
/*
 * Write object information.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      fprintf(fptr, "\nobjtype: %d\n", thisObject->objtype);
      fprintf(fptr, "x: %d\n", thisObject->x);
      fprintf(fptr, "y: %d\n", thisObject->y);
      fprintf(fptr, "width: %d\n", thisObject->width);
      fprintf(fptr, "height: %d\n", thisObject->height);
      fprintf(fptr, "frame: %d\n", thisObject->frame);
      fprintf(fptr, "decoration: %d\n", thisObject->decoration);
      fprintf(fptr, "dec_size: %d\n", thisObject->dec_size);
      fprintf(fptr, "dec_color: %d %d %d\n", thisObject->dec[0],
                                            thisObject->dec[1],
                                            thisObject->dec[2]);
      if (thisObject->objtype == TXTOBJ) {
            fprintf(fptr, "TXTOBJ.text: ");
            startP = thisObject->u.text.text;	/* point to beginning of text */
            endP = strchr(startP, '\n');	/* point to first <CR> */
/*
 * Write parts of text that end with a carriage return.
 */
            while (endP) {
               nchar = (int)(endP-startP);	/* # of chars in first str */
               while (nchar >= MAXSTRLEN) {
                  strncpy(outbuf, startP, MAXSTRLEN-1);
                  outbuf[MAXSTRLEN] = '\0';	/* terminate string */
                  fprintf(fptr, "%s", outbuf);
                  nchar -= MAXSTRLEN-1;
                  startP += MAXSTRLEN-1;
                  }
               strncpy(outbuf, startP, nchar);
               outbuf[nchar] = '\0';		/* terminate string */
               fprintf(fptr, "%s\\n", outbuf);
               startP = endP + 1;		/* point to next str */
               endP = strchr(startP, '\n');	/* find next <CR> */
               }
/*
 * Write trailing text that DOES NOT end with a carriage return.
 */
            while (strlen(startP) >= MAXSTRLEN) {
               strncpy(outbuf, startP, MAXSTRLEN-1);
               outbuf[MAXSTRLEN] = '\0';	/* terminate string */
               fprintf(fptr, "%s", outbuf);
               startP += MAXSTRLEN-1;
               }
            strcpy(outbuf, startP);
            fprintf(fptr, "%s\n", outbuf);
         fprintf(fptr, "TXTOBJ.fontname: %s\n", thisObject->u.text.fontname);
         fprintf(fptr, "TXTOBJ.font: %d\n", thisObject->u.text.font);
         fprintf(fptr, "TXTOBJ.fontstyle: %d\n", thisObject->u.text.fontstyle);
         fprintf(fptr, "TXTOBJ.scale: %f\n", thisObject->u.text.scale);
         fprintf(fptr, "TXTOBJ.color: %d %d %d\n", thisObject->u.text.cv[0],
                                            thisObject->u.text.cv[1],
                                            thisObject->u.text.cv[2]);
         fprintf(fptr, "TXTOBJ.justify: %d\n", thisObject->u.text.justify);
         fprintf(fptr, "TXTOBJ.useShape: %d\n", thisObject->u.text.useShape);
         }
      else if (thisObject->objtype == IMGOBJ) {
         fprintf(fptr, "IMAGE.filename: %s\n", thisObject->u.image.filename);
         fprintf(fptr, "IMAGE.keepaspect: %d\n", thisObject->u.image.keepaspect);
         fprintf(fptr, "IMAGE.orig_width: %d\n", thisObject->u.image.orig_width);
         fprintf(fptr, "IMAGE.orig_height: %d\n", thisObject->u.image.orig_height);
         }
      else if (thisObject->objtype == MAPOBJ) {
         fprintf(fptr, "MAPOBJ.filename: %s\n", thisObject->u.image.filename);
         fprintf(fptr, "MAPOBJ.keepaspect: %d\n", thisObject->u.image.keepaspect);
         fprintf(fptr, "MAPOBJ.orig_width: %d\n", thisObject->u.image.orig_width);
         fprintf(fptr, "MAPOBJ.orig_height: %d\n", thisObject->u.image.orig_height);
         }
      /*thisObject = LlNextObj(theList);*/
      thisObject = UmscListGetNext(theList);
      }
   fclose(fptr);
   needtosave = 0;
}


static void
WriteScriptText(FILE *fptr, GenericInfo *thisObject, int ds)
{
   char	*returnP, *startP, *endP;
   char	scriptbuf[MAXSTRLEN];
   int	nchar;
/*
 * Are there return characters in this string?
 */
   if (strchr(thisObject->u.text.text, '\n')) {
      endP = strchr(thisObject->u.text.text, '\n');
      nchar = (int)(endP-thisObject->u.text.text + 1);
      strncpy(scriptbuf, thisObject->u.text.text, nchar-1);
      scriptbuf[nchar-1] = '\0';
      if (ds) {
         fprintf(fptr, "echo 'Compositing %s (shadow)...'\n", scriptbuf);
         fprintf(fptr, "(texttorle %s %5.1f %d %d %d \\\n",
                        thisObject->u.text.fontname,
             (dblsize?2*thisObject->u.text.scale:thisObject->u.text.scale),
                        thisObject->dec[0],
                        thisObject->dec[1],
                        thisObject->dec[2]);
         }
      else {
         fprintf(fptr, "echo 'Compositing %s...'\n", scriptbuf);
         fprintf(fptr, "(texttorle %s %5.1f %d %d %d \\\n",
                        thisObject->u.text.fontname,
             (dblsize?2*thisObject->u.text.scale:thisObject->u.text.scale),
                        thisObject->u.text.cv[0],
                        thisObject->u.text.cv[1],
                        thisObject->u.text.cv[2]);
         }
      }
   else {	/* no return characters in this string */
      if (ds) {
         fprintf(fptr, "echo 'Compositing %s (shadow)...'\n",
                        thisObject->u.text.text);
         fprintf(fptr, "texttorle %s %5.1f %d %d %d \"%s\" \\\n",
                        thisObject->u.text.fontname,
             (dblsize?2*thisObject->u.text.scale:thisObject->u.text.scale),
                        thisObject->dec[0],
                        thisObject->dec[1],
                        thisObject->dec[2],
                        thisObject->u.text.text);
         }
      else {
         fprintf(fptr, "echo 'Compositing %s...'\n", thisObject->u.text.text);
         fprintf(fptr, "texttorle %s %5.1f %d %d %d \"%s\" \\\n",
                        thisObject->u.text.fontname,
             (dblsize?2*thisObject->u.text.scale:thisObject->u.text.scale),
                        thisObject->u.text.cv[0],
                        thisObject->u.text.cv[1],
                        thisObject->u.text.cv[2],
                        thisObject->u.text.text);
         }
      }
/*
 * Position and composite the text.
 */
   if (thisObject->decoration == DROP_SHADOW) {
      if (ds)
         fprintf(fptr, "	| repos -p %d %d \\\n",
     (dblsize?2*(thisObject->x - desi.back.xoffset + ds):
                (thisObject->x - desi.back.xoffset + ds)),
     (dblsize?2*(desi.back.height + desi.back.yoffset -
                 thisObject->y - thisObject->height):
                (desi.back.height + desi.back.yoffset -
                 thisObject->y - thisObject->height)));
      else
         fprintf(fptr, "	| repos -p %d %d \\\n",
     (dblsize?2*(thisObject->x - desi.back.xoffset):
                (thisObject->x - desi.back.xoffset)),
     (dblsize?2*(desi.back.height + desi.back.yoffset -
                 thisObject->y - thisObject->height + thisObject->dec_size):
                (desi.back.height + desi.back.yoffset -
                 thisObject->y - thisObject->height + thisObject->dec_size)));
      }
   else
      fprintf(fptr, "	| repos -p %d %d \\\n",
  (dblsize?2*(thisObject->x - desi.back.xoffset):
             (thisObject->x - desi.back.xoffset)),
  (dblsize?2*(desi.back.height + desi.back.yoffset -
              thisObject->y - thisObject->height):
             (desi.back.height + desi.back.yoffset -
              thisObject->y - thisObject->height)));
   fprintf(fptr, "	| rlecomp - over $$.rle \\\n");
/*
 * Handle multiple lines of text.
 */
   if (strchr(thisObject->u.text.text, '\n')) {
      fprintf(fptr, "	| into $$.rle) <<EOT\n");
      if (thisObject->u.text.justify == JUSTIFY_CENTER)
         fprintf(fptr, ".CENTER.\n");
      if (thisObject->u.text.justify == JUSTIFY_RIGHT)
         fprintf(fptr, ".RIGHT.\n");
      startP = thisObject->u.text.text;	/* point to beginning of text */
      endP = strchr(startP, '\n');	/* point to first <CR> */
      while (endP) {
         nchar = (int)(endP-startP + 1);	/* # of chars in first str */
         strncpy(scriptbuf, startP, nchar-1);
         scriptbuf[nchar-1] = '\0';		/* terminate string */
         fprintf(fptr, "%s\n", scriptbuf);
         startP = endP + 1;		/* point to next str */
         endP = strchr(startP, '\n');	/* find next <CR> */
         }
      strcpy(scriptbuf, startP);
      fprintf(fptr, "%s\n", scriptbuf);
      fprintf(fptr, "EOT\n");
      }
   else
      fprintf(fptr, "	| into $$.rle\n");
}


static void
WriteScript(char *scriptname)
{
   FILE		*fptr;
   GenericInfo	*thisObject;
   char		*returnP, *startP, *endP;
   char		tempfile[10], scriptbuf[MAXSTRLEN], *extP;
   float	xscale, yscale;
   int		i, n, nchar, x1, x2, y1, y2, nf;
   char		*d_str;
   time_t	second;
/*
 * What is our script name?
 */
   fptr = fopen(scriptname, "w");
   fprintf(fptr, "#!/bin/csh -f\n#\n");
   fprintf(fptr, "#  Desi: image design script\n");
   second = time((long *)NULL);
   d_str = ctime(&second);
   fprintf(fptr, "#  This script generated by %s on %s#\n", getenv("USER"),d_str);
/*
 * Should be assume that this image is to be doubled?
 */
   if (desi.back.width == 1024 &&
      (desi.back.height == 768 || desi.back.height == 683))
      dblsize = 1;
   else
      dblsize = 0;
/*
 * Make a background.
 */
   if (desi.back.ul[0] == 0 && desi.back.ul[1] == 0 && desi.back.ul[2] == 0 &&
       desi.back.ur[0] == 0 && desi.back.ur[1] == 0 && desi.back.ur[2] == 0 &&
       desi.back.ll[0] == 0 && desi.back.ll[1] == 0 && desi.back.ll[2] == 0 &&
       desi.back.lr[0] == 0 && desi.back.lr[1] == 0 && desi.back.lr[2] == 0 ) {
      fprintf(fptr, "#\n#  Create a black background image.\n#\n");
      fprintf(fptr, "echo Creating background...\n");
      fprintf(fptr, "rlebg -s %d %d 0 0 0 > back$$.rle\n",
              (dblsize?2*desi.back.width:desi.back.width),
              (dblsize?2*desi.back.height:desi.back.height));
      }
   else {
      printf("\nWARNING! -- I am unable to reproduce your background using URT tools.\n");
      printf("You may wish to either (a) edit the line containing rlebg in the script.\n");
      printf("or (b) save the background separately and add its filename to the script.\n");
      fprintf(fptr, "#\n#  Create a colored background image.\n");
      fprintf(fptr, "#  NOTE:  This background will not match the one created inside Desi.  This\n");
      fprintf(fptr, "#         is because there is not currently a way to generate that same\n");
      fprintf(fptr, "#         background using Utah Raster Toolkit commands.  To use that\n");
      fprintf(fptr, "#         background, you will have to make a snapshot of only the background\n");
      fprintf(fptr, "#         and replace the \"rlebg\" line with the following line:\n#\n");
      fprintf(fptr, "#cp your-file-name-here.rle back$$.rle\n#\n");
      fprintf(fptr, "echo Creating background...\n");
      fprintf(fptr, "rlebg -s %d %d -v 0.1 0.5 0 0 255 > back$$.rle\n",
              (dblsize?2*desi.back.width:desi.back.width),
              (dblsize?2*desi.back.height:desi.back.height));
      }
   for (nf=1; nf<=nFrames; nf++) {
      if (nFrames == 1) {
         fprintf(fptr, "#\n#  Uncomment the \"while\" and following lines to use the while loop.\n#\n");
         fprintf(fptr, "@ i = 1\n#while ($i <= 1)\n");
         fprintf(fptr, "#   set filename = `echo $i | awk '{printf \"file.%c04d.rle\", $1}'`\n", '%');
         fprintf(fptr, "#   set outname = `echo $i | awk '{printf \"out.%c04d.rle\", $1}'`\n", '%');
         fprintf(fptr, "#\n#  Create the image.\n#\n");
         fprintf(fptr, "echo Creating image number $i\n");
         }
      else {
         fprintf(fptr, "#\n#  Create image number %d.\n#\n", nf);
         fprintf(fptr, "echo Creating image number %d.\n", nf);
         }
      fprintf(fptr, "cp back$$.rle $$.rle\n");
/*
 * Next, create each text image.
 */
      n = 0;
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      for (i=0; i<UmscListGetCount(theList); i++) {
         if (thisObject->frame == nf) {
            if (thisObject->objtype == TXTOBJ) {
               if (thisObject->decoration == DROP_SHADOW)
                  WriteScriptText(fptr, thisObject, thisObject->dec_size);
               WriteScriptText(fptr, thisObject, 0);
               }
            else if (thisObject->objtype == IMGOBJ) {
               fprintf(fptr, "echo Compositing %s...\n", thisObject->u.image.filename);
               if (thisObject->decoration == DROP_SHADOW) {
                  fprintf(fptr, "rlebg -s %d %d %d %d %d \\\n",
                          (dblsize?2*thisObject->width:thisObject->width),
                          (dblsize?2*thisObject->height:thisObject->height),
                          thisObject->dec[0],thisObject->dec[1],thisObject->dec[2]);
                  fprintf(fptr, "	| repos -p %d %d \\\n",
                  (dblsize?2*
                   (thisObject->x - desi.back.xoffset + thisObject->dec_size) :
                   (thisObject->x - desi.back.xoffset + thisObject->dec_size)),
                  (dblsize?2*
                   (desi.back.height + desi.back.yoffset -
                   thisObject->y - thisObject->height - thisObject->dec_size) :
                   (desi.back.height + desi.back.yoffset -
                   thisObject->y - thisObject->height - thisObject->dec_size)));
                  fprintf(fptr, "	| rlecomp - over $$.rle \\\n");
                  fprintf(fptr, "	| into $$.rle\n");
                  }
               extP = strrchr(thisObject->u.image.filename, 46);
               extP++;
               if (!strcmp(extP, "rle"))
                  fprintf(fptr, "cat %s \\\n", thisObject->u.image.filename);
               else if (!strcmp(extP, "gif"))
                  fprintf(fptr, "giftorle %s \\\n", thisObject->u.image.filename);
               else if (!strcmp(extP, "jpg"))
                  fprintf(fptr, "djpeg -R %s \\\n", thisObject->u.image.filename);
               else if (!strcmp(extP, "sgi") || !strcmp(extP, "rgb")) {



                  fprintf(fptr, "rlebg -s %d %d 0 0 0 -o alpha.rle\n",
                          thisObject->u.image.orig_width,
                          thisObject->u.image.orig_height);
                  fprintf(fptr, "iristorle %s >junk.rle\n", thisObject->u.image.filename);
                  fprintf(fptr, "mergechan -a alpha.rle junk.rle junk.rle junk.rle \\\n");

                  }



               if (thisObject->width != thisObject->u.image.orig_width ||
                   thisObject->height != thisObject->u.image.orig_height) {
                  xscale = (double)thisObject->width/thisObject->u.image.orig_width;
                  yscale = (double)thisObject->height/thisObject->u.image.orig_height;
                  fprintf(fptr, "	| fant -p 0 0 -s %f %f \\\n",
                    (dblsize?2.0*xscale:xscale), (dblsize?2.0*yscale:yscale));
                  }
               else if (dblsize)
                  fprintf(fptr, "	| rlezoom 2 \\\n");
               if (thisObject->x < desi.back.xoffset ||
                   thisObject->y < desi.back.yoffset ||
                   thisObject->x+thisObject->width-desi.back.xoffset >
                                     desi.back.width ||
                   thisObject->y+thisObject->height-desi.back.yoffset >
                                    desi.back.height) {
                  x1 = (thisObject->x < desi.back.xoffset ?
                        desi.back.xoffset - thisObject->x : 0);
                  x2 = (thisObject->x+thisObject->width-desi.back.xoffset >
                        desi.back.width ?
                        desi.back.xoffset+desi.back.width-thisObject->x :
                        thisObject->width-1);
                  y1 = (thisObject->y+thisObject->height-desi.back.yoffset >
                        desi.back.height ?
                        thisObject->y+thisObject->height -
                        (desi.back.yoffset+desi.back.height) : 0);
                  y2 = (thisObject->y < desi.back.yoffset ?
                        thisObject->height + thisObject->y - desi.back.yoffset :
                        thisObject->height-1);
                  fprintf(fptr, "	| crop %d %d %d %d \\\n", x1, y1, x2, y2);
                  fprintf(fptr, "	| repos -p %d %d \\\n",
                                     (thisObject->x - desi.back.xoffset + x1),
                                     (desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height + y1));
                  }
               else {
                  fprintf(fptr, "	| repos -p %d %d \\\n",
                       (dblsize?2*(thisObject->x - desi.back.xoffset):
                                  (thisObject->x - desi.back.xoffset)),

                       (dblsize?2*(desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height):
                                  (desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height)));
                  }
               fprintf(fptr, "	| rlecomp - over $$.rle \\\n");
               fprintf(fptr, "	| into $$.rle\n");
               }
            else if (thisObject->objtype == MAPOBJ) {
               fprintf(fptr, "echo Compositing %s...\n", thisObject->u.image.filename);
               if (thisObject->decoration == DROP_SHADOW) {
                  fprintf(fptr, "rlebg -s %d %d %d %d %d \\\n",
                          (dblsize?2*thisObject->width:thisObject->width),
                          (dblsize?2*thisObject->height:thisObject->height),
                          thisObject->dec[0],thisObject->dec[1],thisObject->dec[2]);
                  fprintf(fptr, "	| repos -p %d %d \\\n",
         (dblsize?2*(thisObject->x - desi.back.xoffset + thisObject->dec_size):
                    (thisObject->x - desi.back.xoffset + thisObject->dec_size)),
         (dblsize?2*(desi.back.height + desi.back.yoffset -
                   thisObject->y - thisObject->height - thisObject->dec_size):
                  (desi.back.height + desi.back.yoffset -
                   thisObject->y - thisObject->height - thisObject->dec_size)));
                  fprintf(fptr, "	| rlecomp - over $$.rle \\\n");
                  fprintf(fptr, "	| into $$.rle\n");
                  }
               fprintf(fptr, "rlebg -s 100 256 -l -v 0.0 1.0 255 255 255 \\\n");
               fprintf(fptr, "	| rleswap -f 0 \\\n");
               fprintf(fptr, "	| rleldmap -t %s \\\n",
                                                  thisObject->u.image.filename);
               fprintf(fptr, "	| applymap \\\n");
               if (thisObject->u.image.keepaspect == LEFT)
                  fprintf(fptr, "	| rleflip -l \\\n");
               else if (thisObject->u.image.keepaspect == RIGHT)
                  fprintf(fptr, "	| rleflip -r \\\n");
               else if (thisObject->u.image.keepaspect == FLIP)
                  fprintf(fptr, "	| rleflip -v \\\n");
               if (thisObject->width != thisObject->u.image.orig_width ||
                   thisObject->height != thisObject->u.image.orig_height) {
                  xscale = (double)thisObject->width/thisObject->u.image.orig_width;
                  yscale = (double)thisObject->height/thisObject->u.image.orig_height;
                  fprintf(fptr, "	| fant -p 0 0 -s %f %f \\\n",
                    (dblsize?2.0*xscale:xscale), (dblsize?2.0*yscale:yscale));
                  }
               else if (dblsize)
                  fprintf(fptr, "	| rlezoom 2 \\\n");
               if (thisObject->x < desi.back.xoffset ||
                   thisObject->y < desi.back.yoffset ||
                   thisObject->x+thisObject->width-desi.back.xoffset >
                                     desi.back.width ||
                   thisObject->y+thisObject->height-desi.back.yoffset >
                                    desi.back.height) {
                  x1 = (thisObject->x < desi.back.xoffset ?
                        desi.back.xoffset - thisObject->x : 0);
                  x2 = (thisObject->x+thisObject->width-desi.back.xoffset >
                        desi.back.width ?
                        desi.back.xoffset+desi.back.width-thisObject->x :
                        thisObject->width-1);
                  y1 = (thisObject->y+thisObject->height-desi.back.yoffset >
                        desi.back.height ?
                        thisObject->y+thisObject->height -
                        (desi.back.yoffset+desi.back.height) : 0);
                  y2 = (thisObject->y < desi.back.yoffset ?
                        thisObject->height + thisObject->y - desi.back.yoffset :
                        thisObject->height-1);
                  fprintf(fptr, "	| crop %d %d %d %d \\\n", x1, y1, x2, y2);
                  fprintf(fptr, "	| repos -p %d %d \\\n",
                                     (thisObject->x - desi.back.xoffset + x1),
                                     (desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height + y1));
                  }
               else {
                  fprintf(fptr, "	| repos -p %d %d \\\n",
                          (dblsize?2*(thisObject->x - desi.back.xoffset):
                                     (thisObject->x - desi.back.xoffset)),
                          (dblsize?2*(desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height):
                                     (desi.back.height + desi.back.yoffset -
                                     thisObject->y - thisObject->height)));
                  }
               fprintf(fptr, "	| rlecomp - over $$.rle \\\n");
               fprintf(fptr, "	| into $$.rle\n");
               }	/* endif of MAPOBJ */
            }	/* endif of if (thisObject->frame == nf) */
         thisObject = UmscListGetNext(theList);
         }	/* end of for (i=0; i<UmscListGetCount(theList); i++) */
/*
 * Clean up.
 */
      if (nFrames == 1) {
         fprintf(fptr, "#\n#  Uncomment the following three lines if you wish to use the while loop.\n#\n");
         fprintf(fptr, "#   mv $$.rle $outname\n");
         fprintf(fptr, "#   @ i++\n#end\n");
         }
      startP = strrchr(scriptname, '/');
      startP++;
      endP = strrchr(startP, '.');
      if (endP)
         nchar = (int)(endP - startP);
      else
         nchar = strlen(startP);
      strncpy(scriptbuf, startP, nchar);
      scriptbuf[nchar] = '\0';
      if (nFrames == 1) {
         fprintf(fptr, "mv $$.rle %s.rle\n", scriptbuf);
         if (dblsize)
            fprintf(fptr, "avg4 %s.rle | get4d -g 1\n", scriptbuf);
         else
            fprintf(fptr, "get4d -g 1 %s.rle\n", scriptbuf);
         }
      else {
         fprintf(fptr, "mv $$.rle %s.%04d.rle\n", scriptbuf, nf);
         /*fprintf(fptr, "get4d -g 1 %s.%04d.rle\n", scriptbuf, nf);*/
         }
      }
   fprintf(fptr, "rm -f back$$.rle alpha.rle\n");
   fprintf(fptr, "echo Done.\n");
   fclose(fptr);
   sprintf(scriptbuf, "chmod 755 %s", scriptname);
   system(scriptbuf);
}

void
DumpWindowToRLE(char *filename)
{
   FILE         *pixout;
   char         cmd[80];
   int          bufsiz, i;
   long         bits24;
   unsigned long *wbuf = NULL;

   /*while (XtAppPending(desi.appContext))
      XtAppProcessEvent(desi.appContext,XtIMAll);*/

   GLXwinset(XtDisplay(desi.toplevel), XtWindow(desi.back.w));
   bufsiz = desi.back.width*desi.back.height*4;
   if ((wbuf = (unsigned long *) malloc(bufsiz)) == NULL)
      fprintf(stderr, "Cannot malloc %d bytes.\n", bufsiz);
   lrectread(0, 0, desi.back.width-1, desi.back.height-1, wbuf);
/*
 * If the display has 24 bit planes, the only thing in question
 * is wheather or not we have alpha planes.
 */
   bits24 = getgdesc(GD_BITS_NORM_SNG_RED);
   if (bits24) {
      if (getgdesc(GD_BITS_NORM_SNG_ALPHA) != 8)
         for (i=0; i<desi.back.width*desi.back.height; i++)
            wbuf[i] = (wbuf[i] & 0x00FFFFFF) |
                      (wbuf[i] & 0x00FFFFFF ? 0xFF000000 : 0);
      }
   else /* must only have 8 bits */
      fprintf(stderr, "Can't dump from 8 bit display.\n");
/*
 *  Make an RLE file.
 */
   sprintf(cmd,"rawtorle -w %d -h %d -n 4 -r -o %s",
           desi.back.width,desi.back.height, filename);
   if ((pixout = popen(cmd, "w")) == NULL)
      fprintf(stderr, "Cannot open connection to rawtorle.\n");
   if ((fwrite(wbuf, bufsiz, 1, pixout)) != 1)
      fprintf(stderr, "Cannot write command to pipe.\n");
   pclose(pixout);
}


void
DumpWindowToSGI(char *filename)
{
   long		xorg, yorg, width, height;
   unsigned long *scrbuf;

   GLXwinset(XtDisplay(desi.back.w), XtWindow(desi.back.w));
   getorigin(&xorg, &yorg);
   getsize(&width, &height);

/* malloc buffers */
   scrbuf = (unsigned long *)malloc(width*height*sizeof(long));

/* read the display */
   readdisplay((int)xorg, (int)yorg,
               xorg+width-1, yorg+height-1,
               scrbuf,(unsigned long)0);
               /*scrbuf,RD_FREEZE);*/

/* write the data to the image file */

   if ((longstoimage(scrbuf, width, height, 3, filename)) != 1)
      printf("ERROR: fileMenu problems writing to sgi image file.\n");
   free(scrbuf);
}


static void
DumpBackToRLE(filename)
char	*filename;
{
   GenericInfo	*thisObject;
   int 		i;
/*
 * Temporarily unmanage all objects so that the background can be seen.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      XtUnmanageChild(XtParent(thisObject->w));
      thisObject = UmscListGetNext(theList);
      }
   DrawBackCB(desi.back.w, (XtPointer)0, (char *)0);
/*
 * Dump the background to a file.
 */
   DumpWindowToRLE(filename);
/*
 * Re-manage all objects again.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      XtManageChild(XtParent(thisObject->w));
      thisObject = UmscListGetNext(theList);
      }
}

void
DumpHandler(void)
{
   BusyCursorCB((Widget)0, (XtPointer)0, (char *)0);
   if (dumppending == 1)
      DumpWindowToRLE(filename);
   else
      DumpWindowToSGI(filename);
   UnBusyCursorCB((Widget)0, (XtPointer)0, (char *)0);
}


static void
CheckOpenCB(Widget w, XtPointer client_data, char *call_data)
{
   XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)call_data)->value, XmSTRING_DEFAULT_CHARSET, &filename);
   if ((int)filename[strlen(filename)-1] == '/')
      fprintf(stderr, "Aborting open...\n");
   else {
      NewCB((Widget)0, (XtPointer)0, (char *)0);
      OpenDesi(filename);
      }
}


static void
CheckSaveCB(w, client_data, call_data)
Widget				w;
XtPointer			client_data;
XmSelectionBoxCallbackStruct	*call_data;
{
   XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &filename);
   if ((int)filename[strlen(filename)-1] == '/' || strlen(filename) == 0)
      fprintf(stderr, "Aborting save...\n");
   else {
      if (XmToggleButtonGetState(XtNameToWidget(ssb, "warea.frame.radio.dsave")))
         WriteDesi(filename);
      else if (XmToggleButtonGetState(XtNameToWidget(ssb, "warea.frame.radio.isave")))
         WriteScript(filename);
      /*else if (XmToggleButtonGetState(XtNameToWidget(ssb, "warea.frame.radio.bsave")))
         DumpBackToRLE(filename);*/
      else if (XmToggleButtonGetState(XtNameToWidget(ssb, "warea.frame.radio.usave")))
         dumppending = 1;
      else if (XmToggleButtonGetState(XtNameToWidget(ssb, "warea.frame.radio.ssave")))
         dumppending = 2;
      if (quitpending)
         exit(0);
      }
}


static void
MakeOpenBox(void)
{
   Arg		args[10];
   int		n;
/*
 * Let the user pick a desi file name.
 */
   n = 0;
   osb = XmCreateFileSelectionDialog(desi.toplevel, "osb", args, n);
   XtUnmanageChild(XmFileSelectionBoxGetChild(osb, XmDIALOG_HELP_BUTTON));
   XtAddCallback(osb, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(osb, XmNokCallback, (XtCallbackProc)CheckOpenCB, NULL);
   XtAddCallback(osb, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
}

static void
RadioCB(w, client_data, call_data)
Widget				w;
char				*client_data;
XmToggleButtonCallbackStruct	*call_data;
{
   Arg	args[2];
   int	n;

   n = 0;
   if (!strcmp(client_data, "dsave"))
      XtSetArg(args[n], XmNpattern, XmStringCreateSimple("*.dzi"));
   else if (!strcmp(client_data, "isave"))
      XtSetArg(args[n], XmNpattern, XmStringCreateSimple("*.urt"));
   else if (!strcmp(client_data, "bsave"))
      XtSetArg(args[n], XmNpattern, XmStringCreateSimple("*.rle"));
   else if (!strcmp(client_data, "usave"))
      XtSetArg(args[n], XmNpattern, XmStringCreateSimple("*.rle"));
   else if (!strcmp(client_data, "ssave"))
      XtSetArg(args[n], XmNpattern, XmStringCreateSimple("*.[sr]g[ib]"));
   n++;
   XtSetValues(ssb, args, n);
}


static struct {
   char		*name;		/* name of menu item widget */
   } savelist[] = {
      { "dsave" },
      { "isave" },
      { "usave" },
      { "ssave" }
      };
/*      { "bsave" },*/

static void
MakeSaveBox(void)
{
   Arg		args[10];
   Widget	warea, frame, radio, w;
   int		i, n;
/*
 * Let the user pick a script file name.
 */
   n = 0;
   ssb = XmCreateFileSelectionDialog(desi.toplevel, "ssb", args, n);
   XtUnmanageChild(XmFileSelectionBoxGetChild(ssb, XmDIALOG_HELP_BUTTON));
   XtAddCallback(ssb, XmNokCallback, (XtCallbackProc)unmanageCB, NULL);
   XtAddCallback(ssb, XmNokCallback, (XtCallbackProc)BusyCursorCB, NULL);
   XtAddCallback(ssb, XmNokCallback, (XtCallbackProc)CheckSaveCB, NULL);
   XtAddCallback(ssb, XmNokCallback, (XtCallbackProc)UnBusyCursorCB, NULL);
   XtAddCallback(ssb, XmNcancelCallback, (XtCallbackProc)unmanageCB, NULL);
/*
 * Add a rowcolumn thing to this file selection box.
 */
   n = 0;
   warea = XmCreateWorkArea(ssb, "warea", args, n);
   XtManageChild(warea);
/*
 * Inside the rowcolumn put a frame.
 */
   n = 0;
   frame = XmCreateFrame(warea, "frame", args, n);
   XtManageChild(frame);
/*
 * Inside the frame put a radio box.
 */
   n = 0;
   XtSetArg(args[n], XmNradioBehavior, True); n++;
   radio = XmCreateWorkArea(frame, "radio", args, n);
   XtManageChild(radio);
   n = 0;
   for (i=0; i<XtNumber(savelist); i++) {
      w = XtCreateWidget(savelist[i].name, xmToggleButtonWidgetClass, radio,
                            args, n);
      XtAddCallback(w, XmNarmCallback, (XtCallbackProc)RadioCB, savelist[i].name);
      XtManageChild(w);
      }
}

static void
OpenCB(Widget w, XtPointer client_data, char *call_data)
{
   if (osb == NULL)
      MakeOpenBox();
   XtManageChild(osb);
}

void
SaveAsCB(Widget w, XtPointer client_data, char *call_data)
{
   if (ssb == NULL)
      MakeSaveBox();
   XtManageChild(ssb);
}

static void
Quit(w, client_data, call_data)
Widget 			w;
XtPointer		client_data;
XmAnyCallbackStruct	*call_data;
{
   if (call_data->reason == XmCR_CANCEL) /* actually this is a "No" */
      exit(0);
   else
      quitpending = 1;			/* quit after the thing is saved */
}


static void
CloseInit(void)
{
   Arg          args[10];
   int          n;

   n = 0;
   closeBox = XmCreateQuestionDialog(desi.toplevel, "closeBox", args, n);
   XtAddCallback(closeBox, XmNokCallback, (XtCallbackProc)SaveAsCB, NULL);
   XtAddCallback(closeBox, XmNokCallback, (XtCallbackProc)Quit, NULL);
   XtAddCallback(closeBox, XmNcancelCallback, (XtCallbackProc)Quit, NULL);
   XtAddCallback(closeBox, XmNhelpCallback, (XtCallbackProc)unmanageCB, NULL); /* maybe */
}


static void
ClosePopup(Widget w, XtPointer client_data, char *call_data)
{
   if (needtosave) {
      if (closeBox == NULL)
         CloseInit();
      XtManageChild(closeBox);
      }
   else
      exit(0);
}


static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)(Widget, XtPointer, char*);      /* callback function */
   } list[] = {
      { "about",	AboutCB},
      { NULL,		NULL},
      { "new",		NewCB},
      { "open",		OpenCB},
      { "saveas",	SaveAsCB},
      { NULL,		NULL},
      { "quit",		ClosePopup}
      };

void
FileMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	fileMenu, w;
/*
 * Create pulldown menu.
 */
   n = 0;
   fileMenu = XmCreatePulldownMenu(parent, "fileMenu", arg, n);
/*
 * Create the entries for the file menu.
 */
   for (i = 0; i < XtNumber(list); i++) {
      if (list[i].name != NULL) {
         w = XmCreatePushButton(fileMenu, list[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)list[i].func, list[i].name);
         }
      else 
         w = XmCreateSeparator(fileMenu, "sep", arg, 0);
      XtManageChild(w);
      }
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, fileMenu); n++;
   w = XmCreateCascadeButton(parent, "file", arg, n);
   XtManageChild(w);
} /* FileMenuInit */
