/*
 * file:     editMenu.c
 * author:   Wes Barris
 * date:     4/22/92
 * purpose:  creates Edit menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
extern UmscList	theList;
extern int	needtosave;
extern int	currentFrame;
extern TextInfo	selectedText;

GenericInfo	selectedObject;


void
CutCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n, ntot;
/*
 * Remove any previously cut or copied objects from the paste buffer.
 * NOTE:  The paste buffer is "<= frame 0".
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* how many are initially in the list */
   for (n=0; n<ntot; n++)
      if (thisObject->frame <= 0) {
         UmscListRemove(theList, UmscNEXT);
         thisObject = UmscListGetCurrent(theList);
         }
      else
         thisObject = UmscListGetNext(theList);
/*
 * Remove (and store on -currentFrame) each selected object from the screen.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* get the initial count */
   for (n=0; n<ntot; n++) {
      if (thisObject->selected == True) {
         /*thisObject->x -= 10;
         thisObject->y -= 10;*/
         /*thisObject->frame = -currentFrame;*/
         thisObject->frame = 0;
         thisObject->selected = FALSE;
         XtDestroyWidget(XtParent(thisObject->w));
         if (thisObject->objtype == IMGOBJ) {
            free(thisObject->u.image.imgbuf);
            thisObject->u.image.imgbuf = NULL;
            }
         else if (thisObject->objtype == MAPOBJ) {
            free(thisObject->u.cmap.imgbuf);
            thisObject->u.cmap.imgbuf = NULL;
            }
         needtosave = 1;
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
CopyCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject, *newObject;
   int		n, ntot;
/*
 * Remove any previously cut or copied objects from the paste buffer.
 * NOTE:  The paste buffer is "frame 0".
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* how many are initially in the list */
   for (n=0; n<ntot; n++)
      if (thisObject->frame <= 0) {
         UmscListRemove(theList, UmscNEXT);
         thisObject = UmscListGetCurrent(theList);
         }
      else
         thisObject = UmscListGetNext(theList);
/*
 * Copy all selected objects and put them on frame 0 (the paste buffer).
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* this is how many are initially in the list */
   for (n=0; n<ntot; n++) {
      if (thisObject->selected == True) {
         newObject = (GenericInfo *)malloc(sizeof(GenericInfo));
         newObject->x		= thisObject->x;
         newObject->y		= thisObject->y;
         newObject->width	= thisObject->width;
         newObject->height	= thisObject->height;
         newObject->decoration	= thisObject->decoration;
         newObject->dec_size	= thisObject->dec_size;
         newObject->dec[0]	= thisObject->dec[0];
         newObject->dec[1]	= thisObject->dec[1];
         newObject->dec[2]	= thisObject->dec[2];
         newObject->selected	= False;
         newObject->frame	= -currentFrame;
         newObject->objtype	= thisObject->objtype;
         if (thisObject->objtype == TXTOBJ) {
            strcpy(newObject->u.text.fontname, thisObject->u.text.fontname);
            newObject->u.text.font	= thisObject->u.text.font;
            newObject->u.text.fontstyle = thisObject->u.text.fontstyle;
            newObject->u.text.scale	= thisObject->u.text.scale;
            newObject->u.text.cv[0]	= thisObject->u.text.cv[0];
            newObject->u.text.cv[1]	= thisObject->u.text.cv[1];
            newObject->u.text.cv[2]	= thisObject->u.text.cv[2];
            newObject->u.text.justify	= thisObject->u.text.justify;
            newObject->u.text.useShape	= thisObject->u.text.useShape;
            newObject->u.text.text = (char *)malloc(strlen(thisObject->u.text.text)+1);
            strcpy(newObject->u.text.text, thisObject->u.text.text);
            }
         else if (thisObject->objtype == IMGOBJ || thisObject->objtype == MAPOBJ) {
            newObject->u.image.orig_width = thisObject->u.image.orig_width;
            newObject->u.image.orig_height = thisObject->u.image.orig_height;
            newObject->u.image.keepaspect = thisObject->u.image.keepaspect;
            newObject->u.image.filename = (char *)malloc(strlen(thisObject->u.image.filename)+1);
            strcpy(newObject->u.image.filename, thisObject->u.image.filename);
            newObject->u.image.imgbuf = NULL;
            }
         UmscListSaveCurrent(theList);
         UmscListSetCurrent(theList, UmscLAST);
         UmscListInsert(theList, newObject, UmscNEXT);
         thisObject = UmscListRestoreCurrent(theList);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
PasteCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject, *newObject;
   int		n, ntot;
/*
 * Copy any object on frame 0 (paste buffer) and display on current frame.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   ntot = UmscListGetCount(theList);	/* how many are initially in the list */
   for (n=0; n<ntot; n++) {
      if (thisObject->frame <= 0) {
         newObject = (GenericInfo *)malloc(sizeof(GenericInfo));
/*
 * If the object is pasted back onto the same frame increment the position.
 */
         if (thisObject->frame == -currentFrame) {
            thisObject->x += 10;
            thisObject->y += 10;
            }
         newObject->x		= thisObject->x;
         newObject->y		= thisObject->y;
         newObject->width	= thisObject->width;
         newObject->height	= thisObject->height;
         newObject->selected	= False;
         newObject->frame	= currentFrame;
         newObject->objtype	= thisObject->objtype;
         newObject->decoration	= thisObject->decoration;
         newObject->dec_size	= thisObject->dec_size;
         newObject->dec[0]	= thisObject->dec[0];
         newObject->dec[1]	= thisObject->dec[1];
         newObject->dec[2]	= thisObject->dec[2];
         UmscListSaveCurrent(theList);
         UmscListSetCurrent(theList, UmscLAST);
         UmscListInsert(theList, newObject, UmscNEXT);
         if (thisObject->objtype == TXTOBJ) {
            strcpy(newObject->u.text.fontname, thisObject->u.text.fontname);
            newObject->u.text.font	= thisObject->u.text.font;
            newObject->u.text.fontstyle = thisObject->u.text.fontstyle;
            newObject->u.text.scale	= thisObject->u.text.scale;
            newObject->u.text.cv[0]	= thisObject->u.text.cv[0];
            newObject->u.text.cv[1]	= thisObject->u.text.cv[1];
            newObject->u.text.cv[2]	= thisObject->u.text.cv[2];
            newObject->u.text.justify	= thisObject->u.text.justify;
            newObject->u.text.useShape	= thisObject->u.text.useShape;
            newObject->u.text.text = (char *)malloc(strlen(thisObject->u.text.text)+1);
            strcpy(newObject->u.text.text, thisObject->u.text.text);
            CreateText(newObject);
            }
         else if (thisObject->objtype == IMGOBJ) {
            newObject->u.image.orig_width = thisObject->u.image.orig_width;
            newObject->u.image.orig_height = thisObject->u.image.orig_height;
            newObject->u.image.keepaspect = thisObject->u.image.keepaspect;
            newObject->u.image.filename = (char *)malloc(strlen(thisObject->u.image.filename)+1);
            strcpy(newObject->u.image.filename, thisObject->u.image.filename);
            newObject->u.image.imgbuf = NULL;
            CreateImage(newObject);
            }
         else if (thisObject->objtype == MAPOBJ) {
            newObject->u.image.orig_width = thisObject->u.image.orig_width;
            newObject->u.image.orig_height = thisObject->u.image.orig_height;
            newObject->u.image.keepaspect = thisObject->u.image.keepaspect;
            newObject->u.image.filename = (char *)malloc(strlen(thisObject->u.image.filename)+1);
            strcpy(newObject->u.image.filename, thisObject->u.image.filename);
            newObject->u.cmap.imgbuf = NULL;
            CreateCmap(newObject);
            }
         thisObject = UmscListRestoreCurrent(theList);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
SelAllCB(Widget w, XtPointer client_data, char *call_data)
{
   Arg		args[2];
   GenericInfo	*thisObject;
   int		i, n;
/*
 * Select each object.
 */
   n = 0;
   XtSetArg(args[n], XtNselected, True); n++;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->frame == currentFrame) {
         XtSetValues(XtParent(thisObject->w), args, n);
         thisObject->selected = True;
         }
      thisObject = UmscListGetNext(theList);
      }
}

static void
RaiseCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n, moved;

   if (UmscListGetCount(theList) == 1)
      return;
/*
 * Raise each selected object.
 */
   moved = 0;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0,moved=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->selected == True) {
         XRaiseWindow(XtDisplay(desi.toplevel),
                      XtWindow(XtParent(thisObject->w)));
         needtosave = 1;
         moved++;
         }
      thisObject = UmscListGetNext(theList);
      }
/*
 * Reorginize the list.
 */
   n = 0;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   while (n<moved) {
      if (thisObject->selected == True) {
         UmscListMove(theList, UmscLAST);
         thisObject = UmscListSetCurrent(theList, UmscFIRST);
         n++;
         }
      else
         thisObject = UmscListGetNext(theList);
      }
}

static void
LowerCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n, moved;

   if (UmscListGetCount(theList) == 1)
      return;
/*
 * Lower each selected object.
 */
   moved = 0;
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->selected == True) {
         XLowerWindow(XtDisplay(desi.toplevel),
                      XtWindow(XtParent(thisObject->w)));
         needtosave = 1;
         moved++;
         }
      thisObject = UmscListGetNext(theList);
      }
/*
 * Reorginize the list.
 */
   n = 0;
   thisObject = UmscListSetCurrent(theList, UmscLAST);
   while (n<moved) {
      if (thisObject->selected == True) {
         UmscListMove(theList, UmscFIRST);
         thisObject = UmscListSetCurrent(theList, UmscLAST);
         n++;
         }
      else
         thisObject = UmscListGetPrev(theList);
      }
/*
 * Make sure the background is the bottom widget.
 */
   XLowerWindow(XtDisplay(desi.toplevel), XtWindow(desi.back.w));
}


/*
 * This routine is called whenever an object is clicked on.
 * It will store some text parameters and then make sure the object is
 * raised to the top.
 */
void
SelectCB(Widget selfM, XtPointer client_data, char *call_data)
{
   Arg		args[2];
   GenericInfo	*thisObject;
   int		n;
/*
 * Find the correct object.
 */
   thisObject = (GenericInfo *)client_data;
   /*thisObject = UmscListSetCurrent(theList, UmscFIRST);
   while (thisObject->w != (Widget)client_data)
      thisObject = UmscListGetNext(theList);*/
/*
 * To me this seems like a bug in the selfmoving widget.
 */
   if (thisObject->frame != currentFrame) {
      /*fprintf(stderr, "ERROR -- this object is not on current frame.\n");*/
      n = 0;
      XtSetArg(args[n], XtNselected, False); n++;
      XtSetValues(XtParent(thisObject->w), args, n);
      return;
      }
   thisObject->selected = True;
   selectedObject.w		= thisObject->w;
   selectedObject.x		= thisObject->x;
   selectedObject.y		= thisObject->y;
   selectedObject.width		= thisObject->width;
   selectedObject.height	= thisObject->height;
   selectedObject.frame		= thisObject->frame;
   selectedObject.selected	= thisObject->selected;
   selectedObject.objtype	= thisObject->objtype;
   selectedObject.decoration	= thisObject->decoration;
   selectedObject.dec_size	= thisObject->dec_size;
   selectedObject.dec[0]	= thisObject->dec[0];
   selectedObject.dec[1]	= thisObject->dec[1];
   selectedObject.dec[2]	= thisObject->dec[2];
   if (thisObject->objtype == TXTOBJ) {
      selectedText.text = thisObject->u.text.text;
      strcpy(selectedText.fontname, thisObject->u.text.fontname);
      selectedText.font = thisObject->u.text.font;
      selectedText.fontstyle = thisObject->u.text.fontstyle;
      selectedText.scale = thisObject->u.text.scale;
      selectedText.cv[0] = thisObject->u.text.cv[0];
      selectedText.cv[1] = thisObject->u.text.cv[1];
      selectedText.cv[2] = thisObject->u.text.cv[2];
      selectedText.justify = thisObject->u.text.justify;
      }
   /*else if (thisObject->objtype == IMGOBJ) {*/
      /*selectedImage.filename = thisObject->u.image.filename;*/
      /*selectedImage.keepaspect = thisObject->u.image.keepaspect;*/
      /*selectedImage.orig_width = thisObject->u.image.orig_width;*/
      /*selectedImage.orig_height = thisObject->u.image.orig_height;*/
     /*}*/
   /*else if (thisObject->objtype == MAPOBJ) {*/
      /*selectedImage.filename = thisObject->u.image.filename;*/
      /*selectedImage.keepaspect = thisObject->u.image.keepaspect;*/
      /*selectedImage.orig_width = thisObject->u.image.orig_width;*/
      /*selectedImage.orig_height = thisObject->u.image.orig_height;*/
     /*}*/
   /*RaiseCB((Widget)NULL, (XtPointer)NULL, (char *)NULL);*/
}

void
UnselectCB(Widget selfM, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
/*
 * Find the correct object.
 */
   thisObject = (GenericInfo *)client_data;
   /*thisObject = UmscListSetCurrent(theList, UmscFIRST);
   while (thisObject->w != (Widget)client_data)
      thisObject = UmscListGetNext(theList);*/
   thisObject->selected = False;
}


static struct {
	char		*name;			/* name of menu item widget */
	void		(*callbackFcn)(Widget, XtPointer, char*);/* callback function */
	void		(*initFcn)(Widget);	/* fcn to init client-data */
	} list[] = {
		{ "cut",	CutCB,		NULL		},
		{ "copy",	CopyCB,		NULL		},
		{ "paste",	PasteCB,	NULL		},
		{ "selall",	SelAllCB,	NULL		},
		{ "raise",	RaiseCB,	NULL		},
		{ "lower",	LowerCB,	NULL		},
		{ "dshadow",	DecorationCB,	NULL		},
		{ NULL,		NULL,		CenterMenuInit	},
		{ NULL,		NULL,		SpaceMenuInit	},
		{ NULL,		NULL,		AlignMenuInit	}
		};

void
EditMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	editMenu,
		w;
/*
 * Create the pulldown menu.
 */
   n = 0;
   editMenu = XmCreatePulldownMenu(parent, "editMenu", arg, n);
/*
 * Create its menu items.
 */
   for (i = 0; i < XtNumber(list); i++) 
      if (list[i].name == NULL)
         (list[i].initFcn)(editMenu);
      else {
         w = XmCreatePushButton(editMenu, list[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)list[i].callbackFcn, (XtPointer)0);
            /*list[i].callbackFcn, (list[i].initFcn == NULL) ?*/
            /*list[i].name : (XtPointer)((list[i].initFcn)()));*/
         XtManageChild(w);
         }
/*
 * Create the cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, editMenu); n++;
   w = XmCreateCascadeButton(parent, "edit", arg, n);
   XtManageChild(w);
}
