/*
 * file:     desi.h
 * author:   Wes Barris
 * date:     4/22/92
 * purpose:  header file for Desi application
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1992.
 *
 */

#ifndef DESI_HEADER
#define DESI_HEADER

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Intrinsic.h>

#define MAJOR_VERSION	1
#define MINOR_VERSION	3
#define PETTY_VERSION	2

#define APP_CLASS	("Desi")
#define TXTOBJ		1
#define IMGOBJ		2
#define MAPOBJ		3

#define CREATING	1
#define EDITING		2

/*#define COURIER		1
#define HELVETICA	2
#define SYMBOL		3
#define TIMES		4
#define UTOPIA		5
#define AMIE		6
#define CAVE		7
#define CURL		8
#define DJB		9
#define HAEBERLI	10
#define HONESTY		11
#define INJA		12
#define LAURA		13
#define MESSENGER	14
#define ROCK		15
#define SORORITY	16
#define STROKEB		17
#define STROKER		18
#define ELFIN		19*/

#define ROMAN		1
#define BOLD		2
#define ITALIC		3
#define BOLDITALIC	4

#define NORMAL		0
#define LEFT		1
#define RIGHT		2
#define FLIP		3

#define DROP_SHADOW	1
#define BORDER		2
/*
 * Define characteristics unique to the background.
 */
typedef struct {
	Widget		w;
	int		width;
	int		height;
	short		xoffset;
	short		yoffset;
	short		ul[3];
	short		ur[3];
	short		ll[3];
	short		lr[3];
	} Back;

typedef struct {
	XtAppContext	appContext;
	Widget		toplevel;
	Widget		container;
	Back		back;
	} DESI;
/*
 * Define characteristics unique to text.
 */
typedef struct {
	char		*text;
	char		fontname[30];
	int		font;
	int		fontstyle;
	double		scale;
	short		cv[3];
	short		justify;
	short		useShape;
	Pixmap		shapeMask;
	} TextInfo;
/*
 * Define characteristics unique to images.
 */
typedef struct {
	char		*filename;
	short		keepaspect;
	int		orig_width;
	int		orig_height;
	unsigned long	*imgbuf;
	} ImageInfo;
/*
 * Define characteristics unique to colormaps.
 */
typedef struct {
	char		*filename;
	short		orientation;
	int		orig_width;
	int		orig_height;
	unsigned long	*imgbuf;
	} CmapInfo;
/*
 * Define a structure able to hold one of any object.
 */
typedef struct {
	Widget		w;
	short		x;
	short		y;
	int		width;
	int		height;
	short		selected;
	short		objtype;
	short		frame;
	short		decoration;
	short		dec_size;
	short		dec[3];
	union {
		TextInfo	text;
		ImageInfo	image;
		CmapInfo	cmap;
		} u;
	} GenericInfo;

#endif
