/*
 *      File:	LlistP.h
 *    Module:	libUmsc
 *      Date:	07/21/92
 *    Author:	Daniel B. Waylonis (danw@msc.edu)
 *   Purpose:	Private Header file for linked list routines
 *
 *   Copyright @ 1992 by Research Equipment Inc. (dba)
 *   Minnesota Supercomputer Center, Inc.
 *
 * RESTRICTED RIGHTS LEGEND
 *   Use, duplication, or disclosure of this software and its documentation
 *   by the Government is subject to restrictions as set forth in subdivision
 *   { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 *   clause at 52.227-7013.
 *
 * $Log: ListP.h,v $
 * Revision 1.2  1993/01/20  20:40:57  danw
 * *** empty log message ***
 *
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * 
 */

#ifndef _Umsc_ListP_H
#define _Umsc_ListP_H

#include <Umsc/List.h>

/*-------------------------------------------------------------------------*/
/* Typedef / Structures */

typedef struct _UmscNodeRec
{
    void			*obj;
    struct	_UmscNodeRec	*next;
    struct	_UmscNodeRec	*prev;
} UmscNodeRec, *UmscNode;

typedef struct _UmscListRec
{
    char	init;
    long	cnt;
    UmscNode	first;
    UmscNode	current;
    UmscNode	last;
    UmscNode	saved;		/* can save the current pointer */
    int		(*cmp)();	/* method to compare obj, rtn 0 if match */
    void	(*free)();	/* method to destroy obj */
} UmscListRec;

/*-------------------------------------------------------------------------*/

#endif
   
