/*
 *      File:	Llist.h
 *    Module:	libUmsc
 *      Date:	07/21/92
 *    Author:	Daniel B. Waylonis (danw@msc.edu)
 *   Purpose:	Header file for linked list routines
 *
 *   Copyright @ 1992 by Research Equipment Inc. (dba)
 *   Minnesota Supercomputer Center, Inc.
 *
 * RESTRICTED RIGHTS LEGEND
 *   Use, duplication, or disclosure of this software and its documentation
 *   by the Government is subject to restrictions as set forth in subdivision
 *   { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 *   clause at 52.227-7013.
 *
 * $Log: List.h,v $
 * Revision 1.3  1993/01/20  20:40:57  danw
 * Replaced <Umsc/Umsc.h> with <Umsc/Status.h>
 *
 * Revision 1.2  1993/01/05  16:27:34  danw
 * Changed UmscListDump to return void**.  Added UmscListFindWithFn.
 *
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * 
 */

#ifndef _Umsc_List_H
#define _Umsc_List_H

#include <Umsc/Status.h>

/*-------------------------------------------------------------------------*/
#include <Umsc/ProtoMacro.h>

/*-------------------------------------------------------------------------*/
/* Defines */

#define UmscPREV -1	/* for direction */
#define UmscNEXT -2

#define UmscFIRST -1	/* location for movement */
#define UmscLAST -2

/*-------------------------------------------------------------------------*/
/* Typedef / Structures */

typedef struct _UmscListRec *UmscList;

/*-------------------------------------------------------------------------*/
/* convenience macros */
#define UmscListAppend(list,obj) \
    UmscListInsert(list, obj, UmscNEXT)

/*-------------------------------------------------------------------------*/
/* prototypes */

UmscProtoBegin

void**		UmscListDump _((UmscList));
void		UmscListFree _((UmscList, int));
void*		UmscListFind _((UmscList, void*));
void*		UmscListFindWithFn _((UmscList, int (*c)(), void*));
int		UmscListGetCount _((UmscList));
void*		UmscListGetCurrent _((UmscList));
void*		UmscListGetNext _((UmscList));
void*		UmscListGetPrev _((UmscList));
UmscSTATUS	UmscListInit _((UmscList *, int (*i)(), void (*v)()));
UmscSTATUS	UmscListInsert _((UmscList, void *, int));
char		UmscListIsInitialized _((UmscList));
void		UmscListMove _((UmscList, int));
UmscList	UmscListNew _((int (*i)(), void (*v)()));
void		UmscListRemove _((UmscList, int));
void*		UmscListRestoreCurrent _((UmscList));
void		UmscListSaveCurrent _((UmscList));
void*		UmscListSetCurrent _((UmscList, int));
void		UmscListUnlink _((UmscList, int));

UmscProtoEnd

#endif
