 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_form
   >>>> 	_xvf_free_form
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_form_warning
   >>>> 	_xvf_init_form_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"

static void _xvf_init_form_warning PROTO((char *));
static void _xvf_init_form_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_form_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_form(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *guidepane;
	/*
	 * initializing 'form' Form Info structure
	 */

	forminfo->kdbmedit_struct =
	    kvf_create_struct_from_subformname(form, "form.kdbmedit");
	if (forminfo->kdbmedit_struct == NULL)
	{
	    _xvf_init_form_error("subform 'kdbmedit' on form 'form'", 
			    "form_kdbmedit");
	    return(FALSE);
	}

	/*
	 * initializing 'form->kdbmedit' Subform Info structure
	 */

	forminfo->kdbmedit = (form_kdbmedit *)
				kcalloc(1, sizeof(form_kdbmedit));
	subform = forminfo->kdbmedit_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->kdbmedit->options_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.options");
	if (forminfo->kdbmedit->options_struct == NULL)
	    _xvf_init_form_warning("unknown selection 'options' on subform 'kdbmedit'");

	forminfo->kdbmedit->license_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.license");
	if (forminfo->kdbmedit->license_struct == NULL)
		    _xvf_init_form_warning("unknown selection 'license' on subform 'kdbmedit'");

	forminfo->kdbmedit->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.help");
	if (forminfo->kdbmedit->help_struct == NULL)
		    _xvf_init_form_warning("unknown selection 'help' on subform 'kdbmedit'");

	forminfo->kdbmedit->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.quit");
	if (forminfo->kdbmedit->quit_struct == NULL)
		    _xvf_init_form_warning("quit button 'quit' on subform 'kdbmedit'");
	forminfo->kdbmedit->quit = FALSE;

	forminfo->kdbmedit->keylist_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.keylist");
	if (forminfo->kdbmedit->keylist_struct != NULL)
	{
	    selection = forminfo->kdbmedit->keylist_struct->Selptr;
	    kvf_get_attribute(forminfo->kdbmedit->keylist_struct, KVF_LIST_VAL,
	                    &(forminfo->kdbmedit->keylist));
	    kvf_get_attribute(forminfo->kdbmedit->keylist_struct, KVF_LIST_LABEL,
	                    &(forminfo->kdbmedit->keylist_label));
	}
	else
	    _xvf_init_form_warning("displaylist selection 'keylist' on subform 'kdbmedit'");

	forminfo->kdbmedit->keylist_selected = FALSE;

	forminfo->kdbmedit->edit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.edit");
	if (forminfo->kdbmedit->edit_struct == NULL)
	    _xvf_init_form_warning("pane action button 'edit' on subform 'kdbmedit'");
	forminfo->kdbmedit->edit = FALSE;
	selection = forminfo->kdbmedit->edit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->kdbmedit->delete_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.delete");
	if (forminfo->kdbmedit->delete_struct == NULL)
	    _xvf_init_form_warning("pane action button 'delete' on subform 'kdbmedit'");
	forminfo->kdbmedit->delete = FALSE;
	selection = forminfo->kdbmedit->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->kdbmedit->pixmap_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "form.kdbmedit.pixmap");
	if (forminfo->kdbmedit->pixmap_struct == NULL)
	    _xvf_init_form_warning("blank selection 'pixmap' on subform 'kdbmedit'");

	/*
	 * initializing 'form->kdbmedit->pane' Pane Info structure
	 */

	forminfo->kdbmedit->pane = (kdbmedit_pane *)
				kcalloc(1, sizeof(kdbmedit_pane));
	forminfo->kdbmedit->pane_struct =
	    kvf_create_struct_from_panename(subform, "form.kdbmedit.pane");
	if (forminfo->kdbmedit->pane_struct == NULL)
	{
	    _xvf_init_form_error("pane 'pane' on subform 'kdbmedit'", "kdbmedit_pane");
	    return(FALSE);
	}
	pane = forminfo->kdbmedit->pane_struct->Controlptr;
	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_kdbmedit(forminfo->kdbmedit);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_pane(forminfo->kdbmedit->pane);
	forminfo->kdbmedit->pane->workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.pane.workspace");
	if (forminfo->kdbmedit->pane->workspace_struct == NULL)
	    _xvf_init_form_warning("workspace 'workspace' on pane 'pane' of subform 'kdbmedit'");
	else
	{
	    kvf_get_attribute(forminfo->kdbmedit->pane->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->kdbmedit->pane->workspace));

	}

	/*
	 * initializing 'form->kdbmedit->addpane' Pane Info structure
	 */

	forminfo->kdbmedit->addpane = (kdbmedit_addpane *)
				kcalloc(1, sizeof(kdbmedit_addpane));
	forminfo->kdbmedit->addpane_struct =
	    kvf_create_struct_from_panename(subform, "form.kdbmedit.addpane");
	if (forminfo->kdbmedit->addpane_struct == NULL)
	{
	    _xvf_init_form_error("pane 'addpane' on subform 'kdbmedit'", "kdbmedit_addpane");
	    return(FALSE);
	}
	pane = forminfo->kdbmedit->addpane_struct->Controlptr;
	forminfo->kdbmedit->addpane->allkeys_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.addpane.allkeys");
	if (forminfo->kdbmedit->addpane->allkeys_struct != NULL)
	{
	    selection = forminfo->kdbmedit->addpane->allkeys_struct->Selptr;
	    kvf_get_attribute(forminfo->kdbmedit->addpane->allkeys_struct, KVF_LIST_VAL,
	                    &(forminfo->kdbmedit->addpane->allkeys));
	    kvf_get_attribute(forminfo->kdbmedit->addpane->allkeys_struct, KVF_LIST_LABEL,
	                    &(forminfo->kdbmedit->addpane->allkeys_label));
	}
	else
	    _xvf_init_form_warning("displaylist selection 'allkeys' on pane 'addpane' of subform 'kdbmedit'");

	forminfo->kdbmedit->addpane->allkeys_selected = FALSE;

	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_addpane(forminfo->kdbmedit->addpane);
	forminfo->kdbmedit->addpane->workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.addpane.workspace");
	if (forminfo->kdbmedit->addpane->workspace_struct == NULL)
	    _xvf_init_form_warning("workspace 'workspace' on pane 'addpane' of subform 'kdbmedit'");
	else
	{
	    kvf_get_attribute(forminfo->kdbmedit->addpane->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->kdbmedit->addpane->workspace));

	}
	forminfo->kdbmedit->addpane->addkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.addpane.addkey");
	if (forminfo->kdbmedit->addpane->addkey_struct == NULL)
	    _xvf_init_form_warning("pane action button 'addkey' on pane 'addpane' of subform 'kdbmedit'");
	forminfo->kdbmedit->addpane->addkey = FALSE;
	selection = forminfo->kdbmedit->addpane->addkey_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->kdbmedit->addpane->custom_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.addpane.custom");
	if (forminfo->kdbmedit->addpane->custom_struct != NULL)
	{
	    selection = forminfo->kdbmedit->addpane->custom_struct->Selptr;
	    kvf_get_attribute(forminfo->kdbmedit->addpane->custom_struct, KVF_STRING_DEF,
	                    &(forminfo->kdbmedit->addpane->custom));
	}
	else
	    _xvf_init_form_warning("string selection 'custom' on pane 'addpane' of subform 'kdbmedit'");

	forminfo->kdbmedit->addpane->custom_selected = FALSE;

	forminfo->kdbmedit->addpane->description_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "form.kdbmedit.addpane.description");
	if (forminfo->kdbmedit->addpane->description_struct == NULL)
	    _xvf_init_form_warning("blank selection 'description' on pane 'addpane' of subform 'kdbmedit'");

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_form_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_form_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_form_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_form
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_form_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_form(
    gui_info_struct *forminfo)
{
	if (forminfo->kdbmedit->options_struct != NULL)
	    kfree(forminfo->kdbmedit->options_struct);
	if (forminfo->kdbmedit->license_struct != NULL)
	    kfree(forminfo->kdbmedit->license_struct);
	if (forminfo->kdbmedit->help_struct != NULL)
	    kfree(forminfo->kdbmedit->help_struct);
	if (forminfo->kdbmedit->quit_struct != NULL)
	    kfree(forminfo->kdbmedit->quit_struct);
	if (forminfo->kdbmedit->keylist_struct != NULL)
	    kfree(forminfo->kdbmedit->keylist_struct);
	kfree(forminfo->kdbmedit->keylist_label);
	if (forminfo->kdbmedit->edit_struct != NULL)
	    kfree(forminfo->kdbmedit->edit_struct);
	if (forminfo->kdbmedit->delete_struct != NULL)
	    kfree(forminfo->kdbmedit->delete_struct);
	if (forminfo->kdbmedit->pixmap_struct != NULL)
	    kfree(forminfo->kdbmedit->pixmap_struct);
	if (forminfo->kdbmedit->pane->workspace_struct != NULL)
	    kfree(forminfo->kdbmedit->pane->workspace_struct);
	kfree(forminfo->kdbmedit->pane);
	if (forminfo->kdbmedit->pane_struct != NULL)
	    kfree(forminfo->kdbmedit->pane_struct);

	if (forminfo->kdbmedit->addpane->allkeys_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane->allkeys_struct);
	kfree(forminfo->kdbmedit->addpane->allkeys_label);
	if (forminfo->kdbmedit->addpane->workspace_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane->workspace_struct);
	if (forminfo->kdbmedit->addpane->addkey_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane->addkey_struct);
	kfree(forminfo->kdbmedit->addpane->custom);
	if (forminfo->kdbmedit->addpane->custom_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane->custom_struct);
	if (forminfo->kdbmedit->addpane->description_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane->description_struct);
	kfree(forminfo->kdbmedit->addpane);
	if (forminfo->kdbmedit->addpane_struct != NULL)
	    kfree(forminfo->kdbmedit->addpane_struct);


	if (forminfo->kdbmedit_struct != NULL)
	    kfree(forminfo->kdbmedit_struct);
	kfree(forminfo->kdbmedit);
	kfree(forminfo);
}
