 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_form
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_kdbmedit
   >>>> 	_xvf_get_pane
   >>>> 	_xvf_get_addpane
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_form
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_form(
     gui_info_struct *forminfo)
{
	ksubform   *subform;
	if (forminfo->kdbmedit_struct != NULL)
	{
	    subform = forminfo->kdbmedit_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->kdbmedit_selected));
	    _xvf_get_kdbmedit(forminfo->kdbmedit);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_kdbmedit
| 
|       Purpose: Extracts information from kdbmedit subform
| 
|         Input: subforminfo - pointer to form_kdbmedit structure
| 
|        Output: none
|    Written By: conductor -name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_kdbmedit(
     form_kdbmedit *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->keylist_struct != NULL)
	{
	    selection = subforminfo->keylist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(subforminfo->keylist));
	    if (subforminfo->keylist_label != NULL) kfree(subforminfo->keylist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(subforminfo->keylist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->keylist_selected));
	    }

	}

	if (subforminfo->edit_struct != NULL)
	{
	    selection = subforminfo->edit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->edit));

	}

	if (subforminfo->delete_struct != NULL)
	{
	    selection = subforminfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->delete));

	}

	if (subforminfo->pane_struct != NULL)
	{
	    pane = subforminfo->pane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->pane_selected));
	    _xvf_get_pane(subforminfo->pane);
	}

	if (subforminfo->addpane_struct != NULL)
	{
	    pane = subforminfo->addpane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->addpane_selected));
	    _xvf_get_addpane(subforminfo->addpane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_pane
| 
|       Purpose: Extracts information from pane pane
| 
|         Input: paneinfo - pointer to kdbmedit_pane structure
| 
|        Output: none
|    Written By: conductor -name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_pane(
     kdbmedit_pane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'form->kdbmedit->pane' Pane Info structure
	 */

	if (paneinfo->workspace_struct != NULL)
	{
	    selection = paneinfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_addpane
| 
|       Purpose: Extracts information from addpane pane
| 
|         Input: paneinfo - pointer to kdbmedit_addpane structure
| 
|        Output: none
|    Written By: conductor -name kdbmedit -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_addpane(
     kdbmedit_addpane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'form->kdbmedit->addpane' Pane Info structure
	 */

	if (paneinfo->allkeys_struct != NULL)
	{
	    selection = paneinfo->allkeys_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->allkeys));
	    if (paneinfo->allkeys_label != NULL) kfree(paneinfo->allkeys_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->allkeys_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->allkeys_selected));
	    }

	}

	if (paneinfo->workspace_struct != NULL)
	{
	    selection = paneinfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->workspace));
	    }

	}

	if (paneinfo->addkey_struct != NULL)
	{
	    selection = paneinfo->addkey_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->addkey));

	}

	if (paneinfo->custom_struct != NULL)
	{
	    selection = paneinfo->custom_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->custom != NULL) kfree(paneinfo->custom);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->custom));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->custom_selected));
	    }

	}

}


