 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


#include "kdbmedit.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>              DBM manipulation routine
   >>>>
   >>>>  Private:
   >>>>             initialize_dbm()
   >>>>   Static:
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

kdbm		 *database;
int		  nkeys;
char		**keystrings = NULL;
extern xvobject	  xv_keydata;

/*-----------------------------------------------------------
| Routine Name:	build_key_list - build sorted list of keys in database
| Purpose:	This function builds a sorted list of the keys in the
|		database, storing them in variable keystrings,
|		with the number of keys stored in variable nkeys.
| Input:
| Written By:	Neil Bowers
| Date:		29-sep-94
------------------------------------------------------------*/
static void
build_key_list(
   kstring  defkey)
{
   kdatum   key;
   kstring  keydata;
   int	    i;


   if (keystrings != NULL)
   {
      for (i=0; i<nkeys; i++)
	 kfree(keystrings[i]);
      kfree(keystrings);
   }

   if (defkey == NULL)
      selected_key = 0;

   /*-- zoom through the dbm, to find the number of keys --*/
   nkeys	= 0;
   key	= kdbm_firstkey(database);
   for (; key.dptr; nkeys++, key = kdbm_nextkey(database))
      ;

   if (nkeys != 0)
   {
      /*-- allocate array of string pointers to hold keys --*/
      if ((keystrings = (char **) kmalloc(nkeys * sizeof(char *))) == NULL)
      {
	 kerror(NULL,"initialize_dbm()",
		"couldn't malloc memory to hold array of keys.");
	 return;
      }

      key = kdbm_firstkey(database);
      for (i=0; key.dptr; i++, key = kdbm_nextkey(database))
      {
	 keystrings[i] = kstrdup(key.dptr);
	 if (defkey != NULL && !kstrcmp(key.dptr,defkey))
	    selected_key = i;
      }
      keystrings = karray_sort(keystrings,nkeys,FALSE);
      for (i=0; i<nkeys; i++)
	 if (defkey != NULL && !kstrcmp(keystrings[i],defkey))
	    selected_key = i;
   }

   xvf_set_attributes(keylist,
		      XVF_LIST_SIZE,		nkeys,
		      XVF_LIST_CONTENTS,	keystrings,
		      NULL);

   xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_CLEARTEXT, TRUE);
   if (nkeys > 0)
   {
      if ((keydata = get_dbm_item(selected_key)) != NULL)
      {
	 xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_ADDTEXT, keydata);
	 xvf_set_attribute(keylist,XVF_LIST_INDEX,selected_key);
      }
   }
}


/*-----------------------------------------------------------
| Routine Name:	initialize_dbm - initialize from dbm file
|
| Purpose:	tries to open dbm from file name passed.
|
| Input:	dbmpath - path to dbm, excluding .{pag,dir}
|
| Returns:	TRUE on success, FALSE on failure
|
| Written By:	Neil Bowers
| Date:		22-aug-93
------------------------------------------------------------*/
int
initialize_dbm(
   kstring  dbmpath)
{
   if ((database = kdbm_open(dbmpath, O_RDWR|O_CREAT, 0666)) == NULL)
      return FALSE;

   keystrings = NULL;
   build_key_list(NULL);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	get_dbm_item - get indexed item from dbm
|
| Purpose:	takes an integer, dereferences the list of
|		dbm keys, and returns a string which contains
|		the data for that key.
|
| Input:	keyindex - position of key in key list widget
|
| Returns:	TRUE on success, FALSE on failure
|
| Written By:	Neil Bowers
| Date:		22-aug-93
------------------------------------------------------------*/
char *
get_dbm_item(
   int	   keyindex)
{
   kdatum  key;
   kdatum  data;

   if (keyindex < 0 || keyindex > nkeys-1)
      return NULL;

   key.dptr = keystrings[keyindex];
   key.dsize = kstrlen(keystrings[keyindex]) + 1;
   data = kdbm_fetch(database, key);

   return data.dptr;
}

/*-----------------------------------------------------------
| Routine Name:	edit_dbm_item - edit data value of selected key
|
| Purpose:	Edit's the data associated with the currently
|		selected dbm key.
|
| Input:	keyindex - identifier for currently selected key.
|
| Returns:	TRUE on success, FALSE on failure
|
| Written By:	Neil Bowers
| Date:		Sun Aug 22
------------------------------------------------------------*/
int
edit_dbm_item(
   int		keyindex)
{
   kdatum    key;
   kdatum    data;
   char      title[KLENGTH];
   kstring   filename;
   kstring   dstr;
   int	     dstr_size;


   if (keyindex < 0 || keyindex > nkeys-1)
      return FALSE;

   key.dptr = keystrings[keyindex];
   key.dsize = kstrlen(keystrings[keyindex]) + 1;
   data = kdbm_fetch(database, key);

   if ((filename = ktempnam(NULL,"XXXXXXXXX")) == NULL)
      return FALSE;

   if (kwritefile(filename,(kaddr)data.dptr,0) != data.dsize-1)
      return FALSE;

   ksprintf(title, "Editing key %s", key.dptr);
   keditfile(filename, FALSE,
	     KEDITOR_TITLE, title,
	     KEDITOR_CHDIR, TRUE,
	     NULL);

   dstr = (char *) kreadfile(filename,&dstr_size);
   kunlink(filename);

   /*-- did the contents change? --*/
   if (dstr_size != data.dsize || kstrncmp(dstr,data.dptr,data.dsize))
   {
      data.dptr	= dstr;
      data.dsize	= dstr_size + 1;
      kdbm_store(database,key,data,KDBM_REPLACE);
      xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_CLEARTEXT, TRUE);
      xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_ADDTEXT, kstrdup(data.dptr));
   }

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	close_dbm - close opened dbm database
|
| Purpose:	If a dbm database is currently being edited,
|		then close that puppy.
|
| Written By:	Neil Bowers
| Date:		Sun Aug 22
------------------------------------------------------------*/
void
close_dbm(void)
{
	if (database != NULL)
		kdbm_close(database);
}

/*-----------------------------------------------------------
| Routine Name:	delete_dbm_item - remove named key from dbm
|
| Purpose:	If a dbm database is currently being edited,
|		and a key is selected, remove that puppy.
|
| Input:	keyindex - identifier for the key to remove from
|			   the database.
|
| Written By:	Neil Bowers
| Date:		22-aug-93
------------------------------------------------------------*/
void
delete_dbm_item(
   int	   keyindex)
{
   kdatum  key;


   if (database == NULL || keyindex < 0 || keyindex > nkeys-1)
      return;

   key.dptr = keystrings[keyindex];
   key.dsize = kstrlen(keystrings[keyindex]) + 1;
   if (kdbm_delete(database,key) == -1)
      kerror(NULL,"delete_dbm_item()",
	     "Couldn't remove key from dbm file.");
   else
      build_key_list(NULL);
}

/*-----------------------------------------------------------
| Routine Name:	add_dbm_item - add a new key to the dbm
|
| Purpose:	Add a new key to a dbm, with some default data value.
|
| Input:	The new key to add to the database.
|
| Written By:	Neil Bowers
| Date:		22-aug-93
------------------------------------------------------------*/
void
add_dbm_item(
   kstring  keystring)
{
   kdatum   key;
   kdatum   data;
   kstring  keyvalue = "Frobozz\n";
   kstring  newkey;


   newkey = kstring_cleanup(keystring, NULL);
   if (newkey == NULL)
   {
      kerror(NULL, "add_dbm_item()", "Cannot add an empty key to database!");
      return;
   }

   if (database == NULL)
      return;

   key.dptr	= keystring;
   key.dsize	= kstrlen(keystring) + 1;
   data.dptr	= kstrdup(keyvalue);
   data.dsize	= kstrlen(keyvalue) + 1;
	
   if (kdbm_store(database,key,data,KDBM_INSERT) == 0)
      build_key_list(keystring);
}
