 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kdiffobj
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdiffobj.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - compare the same object in two different toolboxes
|
|       Purpose: main program for kdiffobj
|
|         Input:
|		char *clui_info->oname_string; {Program or Library Object Name}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		M.I. group:
|		    char *clui_info->tb1_string; {First toolbox with object to compare}
|		    int   clui_info->tb1_flag; {TRUE if -tb1 specified}
|
|		    char *clui_info->tb2_string; {Second toolbox with object from}
|		    int   clui_info->tb2_flag; {TRUE if -tb2 specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	klist *list;
	kobject toolbox;
	int   i, token, tb_num = 0;
	char  **toolboxes = NULL, *oname, *tbname1 = NULL, *tbname2 = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kdiffobj_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "kdiffobj",
		kdiffobj_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kdiffobj_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	oname = clui_info->oname_string;
	token = kstring_to_token(oname);
	if (clui_info->tb1_string != NULL)
	   tbname1 = clui_info->tb1_string;

	if (clui_info->tb2_string != NULL)
	   tbname2 = clui_info->tb2_string;

	if (!tbname1 || !tbname2)
	{
	   if ((toolboxes = kcms_query_toolboxes(&tb_num)) == NULL)
	   {
	      kinfo(KSTANDARD, "Warning: No toolboxes accessable in which to \
search for object '%s'", clui_info->oname_string);
	      kexit(KEXIT_FAILURE);
	   }

	   for (i = 0; i < tb_num && (!tbname1 || !tbname2); i++)
	   {
	      if (kstrcasecmp(toolboxes[i], tbname1) == 0 ||
		  kstrcasecmp(toolboxes[i], tbname2) == 0)
	      {
	         continue;
	      }
	      else if ((toolbox = kcms_open_toolbox(toolboxes[i])) == NULL)
	      {
	         kinfo(KSTANDARD, "Warning: Cannot open toolbox object '%s'\n",
			toolboxes[i]);
	         continue;
	      }

	      kcms_get_attribute(toolbox, KCMS_TB_SOFTWARE_OBJECTS, &list);
	      if ((list = klist_locate(list, (kaddr) token)) != NULL)
	      {
		 if (!tbname1)
		    tbname1 = kstring_copy(toolboxes[i], NULL);
		 else
		    tbname2 = kstring_copy(toolboxes[i], NULL);
	      }
	      kcms_close(toolbox);
	   }
	}

	if (!tbname1 && !tbname2)
	{
	   kinfo(KSTANDARD, "Warning: Cannot find any toolbox object with an \
object named '%s'\n", oname);
           kexit(KEXIT_FAILURE);
	}
	else if (!tbname1 || !tbname2)
	{
	   kinfo(KSTANDARD, "Warning: Could only find the toolbox '%s' with \
the object named '%s'\n", oname, (!tbname1) ? tbname1 : tbname2);
           kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!generate_diffobj(tbname1, tbname2, oname))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	karray_free(toolboxes, tb_num, NULL);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdiffobj_usage_additions
| 
|       Purpose: Prints usage additions in kdiffobj_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdiffobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdiffobj_usage_additions(void)
{
	kfprintf(kstderr, "\tcompare the same object in two different toolboxes\n");

/* -usage_additions */
kfprintf(kstderr, "\nIf [-tb1] and [-tb2] are not specified, kdiffobj will\n");
kfprintf(kstderr, "will attempt to find two available toolboxes with the specified\n");
kfprintf(kstderr, "object.  The first two versions of the object will be chosen for\n");
kfprintf(kstderr, "the comparison.\n\n");
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kdiffobj_free_args
| 
|       Purpose: Frees CLUI struct allocated in kdiffobj_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdiffobj
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kdiffobj_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->oname_string);
	kfree(clui_info->tb1_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
